-- Filename: uart_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Mon Feb 24 12:14:34 2025
architecture struct of uart is
    signal enable_receive_clock_divider : std_logic;
    signal enable_send_clock_divider    : std_logic;
    signal receive_clock_enable         : std_logic;
    signal rx_sync                      : std_logic;
    signal send_clock_enable            : std_logic;
    component uart_send is
        generic (
            constant g_data_width  : natural := 8;
            constant g_has_parity         : boolean := true;
            constant g_odd_parity         : boolean := false; -- the number of ones together in databits and paritybit must be odd.
            constant g_number_of_stopbits : natural := 1  
        );
        port (
            clk_i                       : in  std_logic;
            data_i                      : in  std_logic_vector(g_data_width-1 downto 0);
            res_i                       : in  std_logic;
            send_clock_enable_i         : in  std_logic;
            send_i                      : in  std_logic;
            enable_send_clock_divider_o : out std_logic;
            ready_send_o                : out std_logic;
            tx_o                        : out std_logic
        );
    end component;
    component uart_clock_divider is
        generic (
            constant g_divisor_width       : natural := 8; -- allowed values: >= 2
            constant g_fraction_width      : natural := 3; -- allowed values: >= 2
            constant g_create_clock_enable : boolean := true 
        );
        port (
            clk_i                  : in  std_logic;
            clock_divisor_i        : in  unsigned(g_divisor_width-1 downto 0);
            enable_clock_divider_i : in  std_logic;
            fraction_denominator_i : in  unsigned(g_fraction_width-1 downto 0);
            fraction_nominator_i   : in  unsigned(g_fraction_width-1 downto 0);
            res_i                  : in  std_logic;
            clk_divided_o          : out std_logic
        );
    end component;
    component uart_rx_sync is
        generic (
            constant g_number_of_sync_flipflops : natural := 2
        );
        port (
            clk_i     : in  std_logic;
            res_i     : in  std_logic;
            rx_i      : in  std_logic;
            rx_sync_o : out std_logic
        );
    end component;
    component uart_receive is
        generic (
            constant g_divisor_width            : natural := 8;
            constant g_data_width               : natural := 8;
            constant g_has_parity               : boolean := true;
            constant g_odd_parity               : boolean := false
        );
        port (
            clk_i                          : in  std_logic;
            divisor_i                      : in  unsigned(g_divisor_width-1 downto 0);
            receive_clock_enable_i         : in  std_logic;
            res_i                          : in  std_logic;
            rx_sync_i                      : in  std_logic;
            data_o                         : out std_logic_vector(g_data_width-1 downto 0);
            enable_receive_clock_divider_o : out std_logic;
            parity_err_o                   : out std_logic;
            ready_receive_o                : out std_logic
        );
    end component;
begin
    uart_clock_divider_send_inst : uart_clock_divider
        generic map (
            g_divisor_width       => g_divisor_width,
            g_fraction_width      => g_fraction_width,
            g_create_clock_enable => true
        )
        port map (
            clk_i                  => clk_i,
            clock_divisor_i        => clock_divisor_i,
            enable_clock_divider_i => enable_send_clock_divider,
            fraction_denominator_i => fraction_denominator_i,
            fraction_nominator_i   => fraction_nominator_i,
            res_i                  => res_i,
            clk_divided_o          => send_clock_enable
        );
    uart_send_inst : uart_send
        generic map (
            g_data_width         => g_data_width,
            g_has_parity         => g_has_parity,
            g_odd_parity         => g_odd_parity,
            g_number_of_stopbits => g_number_of_stopbits
        )
        port map (
            clk_i                       => clk_i,
            data_i                      => data_i,
            res_i                       => res_i,
            send_clock_enable_i         => send_clock_enable,
            send_i                      => send_i,
            enable_send_clock_divider_o => enable_send_clock_divider,
            ready_send_o                => ready_send_o,
            tx_o                        => tx_o
        );
    uart_rx_sync_inst : uart_rx_sync
        generic map (
            g_number_of_sync_flipflops => g_number_of_sync_flipflops
        )
        port map (
            clk_i     => clk_i,
            res_i     => res_i,
            rx_i      => rx_i,
            rx_sync_o => rx_sync
        );
    uart_clock_divider_receive_inst : uart_clock_divider
        generic map (
            g_divisor_width       => g_divisor_width,
            g_fraction_width      => g_fraction_width,
            g_create_clock_enable => true 
        )
        port map (
            clk_i                  => clk_i,
            clock_divisor_i        => clock_divisor_i,
            enable_clock_divider_i => enable_receive_clock_divider,
            fraction_denominator_i => fraction_denominator_i,
            fraction_nominator_i   => fraction_nominator_i,
            res_i                  => res_i,
            clk_divided_o          => receive_clock_enable
        );
    uart_receive_inst : uart_receive
        generic map (
            g_divisor_width            => g_divisor_width,
            g_data_width               => g_data_width,
            g_has_parity               => g_has_parity,
            g_odd_parity               => g_odd_parity
        )
        port map (
            clk_i                          => clk_i,
            divisor_i                      => clock_divisor_i,
            receive_clock_enable_i         => receive_clock_enable,
            res_i                          => res_i,
            rx_sync_i                      => rx_sync,
            data_o                         => data_o,
            enable_receive_clock_divider_o => enable_receive_clock_divider,
            parity_err_o                   => parity_err_o,
            ready_receive_o                => ready_receive_o
        );
end architecture;
