library ieee;
use ieee.math_real.all;
-- Filename: uart_rx_sync_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Wed Feb 19 14:28:47 2025
architecture struct of uart_rx_sync is
    signal rx_sync : std_logic_vector(g_number_of_sync_flipflops-1 downto 0);
begin
    clocked_g: if g_number_of_sync_flipflops/=0 generate
        process(res_i, clk_i)
        begin
            if res_i='1' then
                rx_sync <= (others => '1');
            elsif rising_edge(clk_i) then
                rx_sync <= rx_i & rx_sync(rx_sync'high downto 1);
            end if;
        end process;
        rx_sync_o <= rx_sync(0);
    end generate clocked_g;
    combinatorial_g: if g_number_of_sync_flipflops=0 generate
        rx_sync_o <= rx_i;
    end generate combinatorial_g;
    process
    begin
        report "flipflop_statistics for instance " & uart_rx_sync'path_name & " signal rx_sync generate-condition == " & boolean'image((g_number_of_sync_flipflops/=0));
        report "flipflop_statistics for instance " & uart_rx_sync'path_name & " signal rx_sync uses " & integer'image(rx_sync'length) & " flipflops.";
        wait;
    end process;
end architecture;
