-- Filename: uart_e.vhd
-- Created by HDL-SCHEM-Editor at Mon Feb 24 12:14:34 2025
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity uart is
    generic (
        constant g_divisor_width            : natural := 8; -- Allowed values: >= 2
        constant g_fraction_width           : natural := 3; -- Allowed values: >= 2
        constant g_data_width               : natural := 8; -- Allowed values: >= 1
        constant g_has_parity               : boolean := true;
        constant g_odd_parity               : boolean := false; -- When "true", then the number of ones together in databits and paritybit must be odd, else even.
        constant g_number_of_stopbits       : natural := 1;
        constant g_number_of_sync_flipflops : natural := 2
    );
    port (
        clk_i                  : in  std_logic;
        clock_divisor_i        : in  unsigned(g_divisor_width-1 downto 0);
        data_i                 : in  std_logic_vector(g_data_width-1 downto 0);
        fraction_denominator_i : in  unsigned(g_fraction_width-1 downto 0);
        fraction_nominator_i   : in  unsigned(g_fraction_width-1 downto 0);
        res_i                  : in  std_logic;
        rx_i                   : in  std_logic;
        send_i                 : in  std_logic;
        data_o                 : out std_logic_vector(g_data_width-1 downto 0);
        parity_err_o           : out std_logic;
        ready_receive_o        : out std_logic;
        ready_send_o           : out std_logic;
        tx_o                   : out std_logic
    );
end entity uart;
