-- Filename: square_root_step_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Sun Jan  5 15:58:20 2025
architecture struct of square_root_step is
    signal delta          : unsigned(2*g_number_of_iterations-1 downto 0);
    signal remainder_next : unsigned(2*g_number_of_iterations downto 0);
    signal root           : unsigned(2*g_number_of_iterations-1 downto 0);
begin
    p_delta: process(root_i, step_i)
    begin
        delta <= root_i;
        delta(2*g_number_of_iterations-2*step_i) <= '1';
    end process;
    remainder_next <= ('0'&remainder_i) - ('0'&delta);
    p_check: process(root_i, remainder_next, step_i, remainder_i)
    begin
        root <= root_i;
        if remainder_next(remainder_next'high)='0' then
            root(2*g_number_of_iterations-1-2*(step_i-1)) <= '1';
            remainder_o <= remainder_next(remainder_o'range);
        else
            remainder_o <= remainder_i;
        end if;
    end process;
    root_o <= shift_right(root, 1);
end architecture;
