-- Filename: square_root_step_e.vhd
-- Created by HDL-SCHEM-Editor at Sun Jan  5 15:58:20 2025
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity square_root_step is
    generic (
        constant g_number_of_iterations : natural := 16;
        constant g_additional_root_bits : natural := 0 
    );
    port (
        remainder_i : in  unsigned(2*g_number_of_iterations-1 downto 0);
        root_i      : in  unsigned(2*g_number_of_iterations-1 downto 0);
        step_i      : in  natural range 1 to g_number_of_iterations;
        remainder_o : out unsigned(2*g_number_of_iterations-1 downto 0);
        root_o      : out unsigned(2*g_number_of_iterations-1 downto 0)
    );
end entity square_root_step;
