-- Filename: testbench_square_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Thu Oct 17 10:42:11 2024
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
architecture struct of testbench_square is
    constant c_period : time := 10 ns;
    constant c_operand_width : natural :=  12;
    constant c_latency       : natural :=  2;
    signal clk            : std_logic := '0';
    signal operand        : signed(c_operand_width-1 downto 0);
    signal product        : signed(2*c_operand_width-1 downto 0);
    signal ready          : std_logic;
    signal res            : std_logic;
    signal run_simulation : std_logic := '1';
    signal start          : std_logic;
    component square is
        generic (
            constant g_operand_width : natural := 16;-- allowed values: 2..
            constant g_latency       : natural := 16 -- allowed values: all
        );
        port (
            clk_i     : in  std_logic;
            operand_i : in  signed(g_operand_width-1 downto 0);
            res_i     : in  std_logic;
            start_i   : in  std_logic;
            ready_o   : out std_logic;
            square_o  : out signed(2*g_operand_width-1 downto 0)
        );
    end component;
begin
    res <= '1', '0' after 1 ns;
    process
    begin
        while run_simulation='1' loop
            clk <= not clk;
            wait for c_period/2;
        end loop;
        wait;
    end process;
    process
        variable r : natural := 0;
        variable d : natural := 0;
    begin
        run_simulation <= '1';
        operand <= (others => '0');
        start <= '0';
        wait for c_period;
        wait for 1 ns;
    
        while d/=2**(operand'length) loop
            start <= '1', '0' after c_period;
            wait until rising_edge(clk);
            while ready/='1' loop
                wait for c_period;
            end loop;
            assert product=(operand*operand) report "Error: product is wrong" severity error;
            wait for 1 ns;
            start <= '0';
            wait for c_period;
            operand <= operand + 1;
            d := d + 1;
        end loop;
        run_simulation <= '0';
        wait;
    end process;
    square_inst : square
        generic map (
            g_operand_width => c_operand_width,-- allowed values: 2..
            g_latency       => c_latency       -- allowed values: all
        )
        port map (
            clk_i     => clk,
            operand_i => operand,
            res_i     => res,
            start_i   => start,
            ready_o   => ready,
            square_o  => product
        );
end architecture;
