-- Filename: square_step_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Fri Oct 18 10:22:47 2024
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
architecture struct of square_step is
    signal operand_int_masked : unsigned(g_operand_width_internal-2 downto 0);
    signal operand_int_mod    : unsigned(g_operand_width_internal-2 downto 0);
    signal partial_sum        : unsigned(g_operand_width_internal-2 downto 0);
    signal partial_sum_in_ext : unsigned(g_operand_width_internal-2 downto 0);
    signal product            : unsigned(g_operand_width_internal-2 downto 0);
begin
    -- Prepare for 2's complement:
    operand_int_mod <=     operand_int_i when fix_negative_operand_i='0' else
                       not operand_int_i;
    -- Clear the not needed upper bits:
    operand_int_masked <= operand_int_mod and mask_i;
    -- Multiply operand_int_masked by factor_bit_i:
    product <= (operand_int_masked'range => factor_bit_i) and operand_int_masked;
    -- Replace a bit (with value 0) by factor_bit_i at one specific place in partial_sum_i:
    partial_sum_in_ext <= partial_sum_i or
                       (
                        (g_operand_width_internal-2 downto 0 => factor_bit_i) and
                         mask_i and
                         not ('0' & mask_i(g_operand_width_internal-2 downto 1))
                        );
    -- New partial sum (with 2's complement carry-in active at negative operands):
    partial_sum <= partial_sum_in_ext + product + unsigned'(""&(fix_negative_operand_i and factor_bit_i));
    -- Shift the result:
    partial_sum_lsb_o <= partial_sum(0);
    partial_sum_o <= '0' & partial_sum(g_operand_width_internal-2 downto 1);
end architecture;
