-- Filename: testbench_rotate_rotation_mode_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Fri Oct 18 14:33:10 2024
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.math_real.all;
use work.testbench_rotate_package.all;
architecture struct of testbench_rotate_rotation_mode is
    constant c_period                   : time    := 10 ns;
    constant c_angle_width              : natural := 28;
    constant c_coordinate_width         : natural := 25;
    constant c_latency_rotate_by_cordic : natural := 26;
    constant c_improved_accuracy        : boolean := false;
    signal clk             : std_logic := '0';
    signal ready           : std_logic;
    signal res             : std_logic;
    signal rotation_angle  : signed(c_angle_width-1 downto 0);
    signal run_simulation  : std_logic := '1';
    signal start           : std_logic;
    signal vector_mode     : std_logic;
    signal x_coord         : signed(c_coordinate_width-1 downto 0) := (others => '0');
    signal x_coord_rotated : signed(c_coordinate_width downto 0);
    signal y_coord         : signed(c_coordinate_width-1 downto 0) := (others => '0');
    signal y_coord_rotated : signed(c_coordinate_width downto 0);
    component rotate is
        generic (
            constant g_angle_width               : natural := 30; -- allowed values    : g_angle_width <= 666
            constant g_coordinate_width          : natural := 27; -- recommended value : g_angle_width-3
            constant g_latency_lengthen_vector   : natural := 1;  -- allowed values    : 0..1 (values >1 are set to 1)
            constant g_latency_rotate_by_90      : natural := 1;  -- allowed values    : 0..1 (values >1 are set to 1)
            constant g_latency_rotate_by_cordic  : natural := 28; -- recommended values: 0..g_angle_width-2
            constant g_latency_fix_cordic_length : natural := 1;  -- allowed values    : 0..1 (values >1 are set to 1)
            constant g_latency_shorten_vector    : natural := 1;  -- allowed values    : 0..1 (values >1 are set to 1)
            constant g_improved_accuracy         : boolean := true
        );
        port (
            clk_i            : in  std_logic;
            res_i            : in  std_logic;
            rotation_angle_i : in  signed(g_angle_width-1 downto 0);
            start_i          : in  std_logic;
            vector_mode_i    : in  std_logic;
            x_coord_i        : in  signed(g_coordinate_width-1 downto 0);
            y_coord_i        : in  signed(g_coordinate_width-1 downto 0);
            ready_o          : out std_logic;
            rotation_angle_o : out signed(g_angle_width-1 downto 0);
            x_coord_o        : out signed(g_coordinate_width downto 0);
            y_coord_o        : out signed(g_coordinate_width downto 0)
        );
    end component;
begin
    res <= '1', '0' after 1 ns;
    process
    begin
        while run_simulation='1' loop
            clk <= not clk;
            wait for c_period/2;
        end loop;
        wait;
    end process;
    rotate_inst : rotate
        generic map (
            g_angle_width               => c_angle_width,
            g_coordinate_width          => c_coordinate_width,
            g_latency_lengthen_vector   => 1,
            g_latency_rotate_by_90      => 1,
            g_latency_rotate_by_cordic  => c_latency_rotate_by_cordic,
            g_latency_fix_cordic_length => 1,
            g_latency_shorten_vector    => 1,
            g_improved_accuracy         => c_improved_accuracy
        )
        port map (
            clk_i            => clk,
            res_i            => res,
            rotation_angle_i => rotation_angle,
            start_i          => start,
            vector_mode_i    => vector_mode,
            x_coord_i        => x_coord,
            y_coord_i        => y_coord,
            ready_o          => ready,
            rotation_angle_o => open,
            x_coord_o        => x_coord_rotated,
            y_coord_o        => y_coord_rotated
        );
    -- The calculation of the x- and y-coordinates is done by vectors and not done by integers.
    -- This has the advantage, that the VHDL integer range is never exceeded, even if the coordinates
    -- have a lot of bits.
    -- The vectors are calculated here in a way that they fit to the reference values which were
    -- calculated with a Python3 program, which you can find here after the stimuli process.
    stimuli: process
        variable x_coord_var     : signed(c_coordinate_width-1 downto 0);
        variable y_coord_var     : signed(c_coordinate_width-1 downto 0);
        variable angle_increment : signed(c_angle_width-1 downto 0);
        variable division_factor : natural;
        variable steps           : natural;
        variable increment       : unsigned(c_coordinate_width-1 downto 0);
        variable angle_in        : signed(c_angle_width-1 downto 0);
        variable angle_out       : signed(c_angle_width-1 downto 0);
        variable x_coord_out     : signed(c_coordinate_width downto 0);
        variable y_coord_out     : signed(c_coordinate_width downto 0);
        variable delta_x         : signed(c_coordinate_width downto 0);
        variable delta_y         : signed(c_coordinate_width downto 0);
        variable delta_x_max     : signed(c_coordinate_width downto 0);
        variable delta_y_max     : signed(c_coordinate_width downto 0);
        variable delta_x_max_max : signed(c_coordinate_width downto 0);
        variable delta_y_max_max : signed(c_coordinate_width downto 0);
        variable shift_number    : natural;
    begin
        run_simulation <= '1';
        vector_mode    <= '0'; -- rotation by angle
        x_coord        <= (others => '0');
        y_coord        <= (others => '0');
        rotation_angle <= (others => '0');
        rotation_angle(rotation_angle'high) <= '1'; -- -180 degree
        start          <= '0';
        wait for 1.6 * c_period;
        angle_increment := (others => '0');
        angle_increment(angle_increment'high-3) := '1'; -- 1/16 of 2*PI
        for angle in 0 to 15 loop
            delta_x_max_max := (others => '0');
            delta_y_max_max := (others => '0');
            report "angle = " & integer'image(angle);
            for shift in 0 to 15 loop
                report "shift = " & integer'image(shift);
                shift_number := shift; -- Used to decrease the length of all simulated vectors.
                -- The increment is the delta for the x or for y-coordinate of the next vector.
                -- First the increment is initialized with the whole range which must be covered at total.
                -- The whole range is from the smallest negative coordinate to the biggest positive coordinate.
                -- As the variable increment has no sign, this range has a size of:
                increment := (others => '0');
                increment(increment'high) := '1';
                -- As the vectors are shrinked by shiftnumber, the whole range must also be shrinked.
                increment := shift_right(increment, shift_number);
                -- The whole range shall be divided into 2**division_factor steps:
                division_factor := 7;
                increment := shift_right(increment,division_factor-1);
                steps := 2**division_factor;
                -- Case 1
                report "Case 1";
                -- Initialize the delta statistic:
                delta_x_max := (others => '0');
                delta_y_max := (others => '0');
                x_coord_var                   := (others => '1');
                x_coord_var(x_coord_var'high) := '0'; -- biggest positive number
                x_coord_var                   := shift_right(x_coord_var, shift_number);
                x_coord_var                   := x_coord_var - signed(increment);
                x_coord_var                   := x_coord_var + 1; -- now "x_coord_var + increment" gives a number which is bigger by 1 as the biggest positive number.
                x_coord <= x_coord_var;
                y_coord_var                   := (others => '0');
                y_coord_var(y_coord'high)     := '1'; -- smallest negative number
                y_coord_var                   := shift_right(y_coord_var, shift_number);
                for i in 0 to steps-1 loop
                    y_coord <= y_coord_var;
                    start <= '1', '0' after c_period;
                    wait until ready='1';
                    angle_in := rotation_angle;
                    rotate_by_cordic(vector_mode, x_coord_var, y_coord_var, angle_in, angle_out, x_coord_out, y_coord_out);
                    delta_x := x_coord_rotated-x_coord_out;
                    delta_y := y_coord_rotated-y_coord_out;
                    if delta_x(delta_x'high)='1' then
                        delta_x := - delta_x;
                    end if;
                    if delta_x>delta_x_max then
                        delta_x_max := delta_x;
                    end if;
                    if delta_y(delta_y'high)='1' then
                        delta_y := - delta_y;
                    end if;
                    if delta_y>delta_y_max then
                        delta_y_max := delta_y;
                    end if;
                    wait for c_period/10;
                    wait for c_period;
                    y_coord_var := y_coord_var + signed(increment);
                end loop;
                --report "delta_x_max = " & integer'image(integer(delta_x_max));
                --report "delta_y_max = " & integer'image(integer(delta_y_max));
                if delta_x_max>delta_x_max_max then
                    delta_x_max_max := delta_x_max;
                end if;
                if delta_y_max>delta_y_max_max then
                    delta_y_max_max := delta_y_max;
                end if;
                -- Case 2
                report "Case 2";
                -- Initialize the delta statistic:
                delta_x_max := (others => '0');
                delta_y_max := (others => '0');
                y_coord_var                   := (others => '1');
                y_coord_var(x_coord_var'high) := '0';
                y_coord_var                   := shift_right(y_coord_var, shift_number);
                y_coord_var                   := y_coord_var - signed(increment);
                y_coord_var                   := y_coord_var + 1;
                y_coord <= y_coord_var;
                x_coord_var                   := (others => '0');
                x_coord_var(x_coord'high)     := '1';
                x_coord_var                   := shift_right(x_coord_var, shift_number);
                for i in 0 to steps-1 loop
                    x_coord <= x_coord_var;
                    start <= '1', '0' after c_period;
                    wait until ready='1';
                    rotate_by_cordic(vector_mode, x_coord_var, y_coord_var, angle_in, angle_out, x_coord_out, y_coord_out);
                    delta_x := x_coord_rotated-x_coord_out;
                    delta_y := y_coord_rotated-y_coord_out;
                    if delta_x(delta_x'high)='1' then
                        delta_x := - delta_x;
                    end if;
                    if delta_x>delta_x_max then
                        delta_x_max := delta_x;
                    end if;
                    if delta_y(delta_y'high)='1' then
                        delta_y := - delta_y;
                    end if;
                    if delta_y>delta_y_max then
                        delta_y_max := delta_y;
                    end if;
                    wait for c_period/10;
                    wait for c_period;
                    x_coord_var := x_coord_var + signed(increment);
                end loop;
                --report "delta_x_max = " & integer'image(integer(delta_x_max));
                --report "delta_y_max = " & integer'image(integer(delta_y_max));
                if delta_x_max>delta_x_max_max then
                    delta_x_max_max := delta_x_max;
                end if;
                if delta_y_max>delta_y_max_max then
                    delta_y_max_max := delta_y_max;
                end if;
                -- Case 3
                report "Case 3";
                -- Initialize the delta statistic:
                delta_x_max := (others => '0');
                delta_y_max := (others => '0');
                x_coord_var                   := (others => '0');
                x_coord_var(x_coord_var'high) := '1';
                x_coord_var                   := shift_right(x_coord_var, shift_number);
                x_coord <= x_coord_var;
                y_coord_var                   := (others => '0');
                y_coord_var(y_coord'high)     := '1';
                y_coord_var                   := shift_right(y_coord_var, shift_number);
                for i in 0 to steps-1 loop
                    y_coord <= y_coord_var;
                    start <= '1', '0' after c_period;
                    wait until ready='1';
                    rotate_by_cordic(vector_mode, x_coord_var, y_coord_var, angle_in, angle_out, x_coord_out, y_coord_out);
                    delta_x := x_coord_rotated-x_coord_out;
                    delta_y := y_coord_rotated-y_coord_out;
                    if delta_x(delta_x'high)='1' then
                        delta_x := - delta_x;
                    end if;
                    if delta_x>delta_x_max then
                        delta_x_max := delta_x;
                    end if;
                    if delta_y(delta_y'high)='1' then
                        delta_y := - delta_y;
                    end if;
                    if delta_y>delta_y_max then
                        delta_y_max := delta_y;
                    end if;
                    wait for c_period/10;
                    wait for c_period;
                    y_coord_var := y_coord_var + signed(increment);
                end loop;
                --report "delta_x_max = " & integer'image(integer(delta_x_max));
                --report "delta_y_max = " & integer'image(integer(delta_y_max));
                if delta_x_max>delta_x_max_max then
                    delta_x_max_max := delta_x_max;
                end if;
                if delta_y_max>delta_y_max_max then
                    delta_y_max_max := delta_y_max;
                end if;
                -- Case 4
                report "Case 4";
                -- Initialize the delta statistic:
                delta_x_max := (others => '0');
                delta_y_max := (others => '0');
                y_coord_var                   := (others => '0');
                y_coord_var(x_coord_var'high) := '1';
                y_coord_var                   := shift_right(y_coord_var, shift_number);
                y_coord <= y_coord_var;
                x_coord_var                   := (others => '0');
                x_coord_var(x_coord'high)     := '1';
                x_coord_var                   := shift_right(x_coord_var, shift_number);
                for i in 0 to steps-1 loop
                    x_coord <= x_coord_var;
                    start <= '1', '0' after c_period;
                    wait until ready='1';
                    rotate_by_cordic(vector_mode, x_coord_var, y_coord_var, angle_in, angle_out, x_coord_out, y_coord_out);
                    delta_x := x_coord_rotated-x_coord_out;
                    delta_y := y_coord_rotated-y_coord_out;
                    if delta_x(delta_x'high)='1' then
                        delta_x := - delta_x;
                    end if;
                    if delta_x>delta_x_max then
                        delta_x_max := delta_x;
                    end if;
                    if delta_y(delta_y'high)='1' then
                        delta_y := - delta_y;
                    end if;
                    if delta_y>delta_y_max then
                        delta_y_max := delta_y;
                    end if;
                    wait for c_period/10;
                    wait for c_period;
                    x_coord_var := x_coord_var + signed(increment);
                end loop;
                --report "delta_x_max = " & integer'image(integer(delta_x_max));
                --report "delta_y_max = " & integer'image(integer(delta_y_max));
                if delta_x_max>delta_x_max_max then
                    delta_x_max_max := delta_x_max;
                end if;
                if delta_y_max>delta_y_max_max then
                    delta_y_max_max := delta_y_max;
                end if;
            end loop; -- over shift_number
            report "delta_x_max_max = " & to_hstring(delta_x_max_max);
            report "delta_y_max_max = " & to_hstring(delta_y_max_max);
            rotation_angle <= rotation_angle + angle_increment;
        end loop; -- over angle
        run_simulation <= '0';
        wait;
    end process;
end architecture;
