-- Filename: testbench_rotate_vector_mode_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Tue Apr 16 16:17:09 2024
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.testbench_rotate_package.all;
architecture struct of testbench_rotate_vector_mode is
    constant c_period                   : time    := 10 ns;
    constant c_improved_accuracy        : boolean := true;
    constant c_angle_width              : natural := 28;
    constant c_coordinate_width         : natural := 25; 
    constant c_latency_rotate_by_cordic : natural := 26;
    signal clk                          : std_logic := '0';
    signal ready                        : std_logic;
    signal res                          : std_logic;
    signal rotation_angle               : signed(c_angle_width-1 downto 0);
    signal rotation_angle_rotation_mode : signed(c_angle_width-1 downto 0);
    signal run_simulation               : std_logic := '1';
    signal start                        : std_logic;
    signal vector_mode                  : std_logic;
    signal x_coord                      : signed(c_coordinate_width-1 downto 0) := (others => '0');
    signal x_coord_rotated              : signed(c_coordinate_width downto 0);
    signal y_coord                      : signed(c_coordinate_width-1 downto 0) := (others => '0');
    signal y_coord_rotated              : signed(c_coordinate_width downto 0);
    component rotate is
        generic (
            constant g_angle_width               : natural := 30; -- allowed values    : g_angle_width <= 666
            constant g_coordinate_width          : natural := 27; -- recommended value : g_angle_width-3
            constant g_latency_lengthen_vector   : natural := 1;  -- allowed values    : 0..1 (values >1 are set to 1)
            constant g_latency_rotate_by_90      : natural := 1;  -- allowed values    : 0..1 (values >1 are set to 1)
            constant g_latency_rotate_by_cordic  : natural := 28; -- recommended values: 0..g_angle_width-2
            constant g_latency_fix_cordic_length : natural := 1;  -- allowed values    : 0..1 (values >1 are set to 1)
            constant g_latency_shorten_vector    : natural := 1;  -- allowed values    : 0..1 (values >1 are set to 1)
            constant g_improved_accuracy         : boolean := true
        );
        port (
            clk_i            : in  std_logic;
            res_i            : in  std_logic;
            rotation_angle_i : in  signed(g_angle_width-1 downto 0);
            start_i          : in  std_logic;
            vector_mode_i    : in  std_logic;
            x_coord_i        : in  signed(g_coordinate_width-1 downto 0);
            y_coord_i        : in  signed(g_coordinate_width-1 downto 0);
            ready_o          : out std_logic;
            rotation_angle_o : out signed(g_angle_width-1 downto 0);
            x_coord_o        : out signed(g_coordinate_width downto 0);
            y_coord_o        : out signed(g_coordinate_width downto 0)
        );
    end component;
begin
    res <= '1', '0' after 1 ns;
    process
    begin
        while run_simulation='1' loop
            clk <= not clk;
            wait for c_period/2;
        end loop;
        wait;
    end process;
    rotate_inst : rotate
        generic map (
            g_angle_width               => c_angle_width,
            g_coordinate_width          => c_coordinate_width,
            g_latency_lengthen_vector   => 1,
            g_latency_rotate_by_90      => 1,
            g_latency_rotate_by_cordic  => c_latency_rotate_by_cordic,
            g_latency_fix_cordic_length => 1,
            g_latency_shorten_vector    => 1,
            g_improved_accuracy         => c_improved_accuracy
        )
        port map (
            clk_i            => clk,
            res_i            => res,
            rotation_angle_i => rotation_angle_rotation_mode,
            start_i          => start,
            vector_mode_i    => vector_mode,
            x_coord_i        => x_coord,
            y_coord_i        => y_coord,
            ready_o          => ready,
            rotation_angle_o => rotation_angle,
            x_coord_o        => x_coord_rotated,
            y_coord_o        => y_coord_rotated
        );
    -- The calculation of the x- and y-coordinates is done by vectors and not done by integers.
    -- This has the advantage, that the VHDL integer range is never exceeded, even if the coordinates
    -- have a lot of bits.
    stimuli: process
        variable x_coord_var            : signed(c_coordinate_width-1 downto 0);
        variable y_coord_var            : signed(c_coordinate_width-1 downto 0);
        variable division_factor        : natural;
        variable steps                  : natural;
        variable increment              : unsigned(c_coordinate_width-1 downto 0);
        variable angle_in               : signed(c_angle_width-1 downto 0) := (others => '0');
        variable angle_out              : signed(c_angle_width-1 downto 0);
        variable x_coord_out            : signed(c_coordinate_width downto 0);
        variable y_coord_out            : signed(c_coordinate_width downto 0);
        variable delta_angle            : signed(c_angle_width-1 downto 0);
        variable delta_angle_max        : signed(c_angle_width-1 downto 0);
        variable delta_angle_sum        : signed(c_angle_width-1 downto 0);
        variable delta_length           : signed(c_coordinate_width downto 0);
        variable delta_length_max       : signed(c_coordinate_width downto 0);
        variable delta_length_sum       : signed(c_coordinate_width downto 0);
        variable shift_number           : natural;
    begin
        run_simulation <= '1';
        vector_mode    <= '1'; -- rotation to x axis
        x_coord        <= (others => '0');
        y_coord        <= (others => '0');
        rotation_angle_rotation_mode <= (others => '0');
        start          <= '0';
        wait for 1.6 * c_period;
        for shift in 0 to 9 loop
            shift_number := shift; -- Used to decrease the length of all simulated vectors.
            -- The increment is the delta for the x or for y-coordinate of the next vector.
            -- First the increment is initialized with the whole range which must be covered at total.
            -- The whole range is from the smallest negative coordinate to the biggest positive coordinate.
            -- As the variable increment has no sign, this range has a size of:
            increment                 := (others => '0');
            increment(increment'high) := '1';
            -- As the vectors are shrinked by shiftnumber, the whole range must also be shrinked.
            increment                 := shift_right(increment, shift_number);
            -- The whole range shall be divided into 2**division_factor steps:
            division_factor := 7;
            increment := shift_right(increment,division_factor-1);
            steps := 2**division_factor;
            -- Initialize the delta statistic:
            delta_angle_max  := (others => '0');
            delta_angle_sum  := (others => '0');
            delta_length_max := (others => '0');
            delta_length_sum := (others => '0');
            -- Case 1
            report "case1";
            x_coord_var                   := (others => '1');
            x_coord_var(x_coord_var'high) := '0'; -- biggest positive number
            x_coord_var                   := shift_right(x_coord_var, shift_number);
            x_coord_var                   := x_coord_var - signed(increment);
            x_coord_var                   := x_coord_var + 1; -- now "x_coord_var + increment" gives a number which is bigger by 1 as the biggest positive number.
            x_coord <= x_coord_var;
            y_coord_var                   := (others => '0');
            y_coord_var(y_coord'high)     := '1'; -- smallest negative number
            y_coord_var                   := shift_right(y_coord_var, shift_number);
            for i in 0 to steps-1 loop
                y_coord <= y_coord_var;
                start <= '1', '0' after c_period;
                wait until ready='1';
                rotate_by_cordic(vector_mode, x_coord_var, y_coord_var, angle_in, angle_out, x_coord_out, y_coord_out);
                delta_angle  := rotation_angle  - angle_out;
                delta_length := x_coord_rotated - x_coord_out;
                if delta_angle/=0 or delta_length/=0 then
                    --report "delta_angle  = " & to_hstring(delta_angle);
                    --report "delta_length = " & to_hstring(delta_length);
                end if;
                if delta_angle<0 then
                    delta_angle := - delta_angle;
                end if;
                delta_angle_sum := delta_angle_sum + delta_angle;
                if delta_angle>delta_angle_max then
                    delta_angle_max := delta_angle;
                end if;
                if delta_length<0 then
                    delta_length := - delta_length;
                end if;
                delta_length_sum := delta_length_sum + delta_length;
                if delta_length>delta_length_max then
                    delta_length_max := delta_length;
                end if;
                y_coord_var := y_coord_var + signed(increment);
                wait for c_period/10;
                wait for c_period;
            end loop;
            -- Case 2
            report "case2";
            y_coord_var                   := (others => '1');
            y_coord_var(y_coord_var'high) := '0';
            y_coord_var                   := shift_right(y_coord_var, shift_number);
            y_coord_var                   := y_coord_var - signed(increment);
            y_coord_var                   := y_coord_var + 1;
            y_coord <= y_coord_var;
            x_coord_var                   := (others => '0');
            x_coord_var(x_coord'high)     := '1';
            x_coord_var                   := shift_right(x_coord_var, shift_number);
            for i in 0 to steps-1 loop
                x_coord <= x_coord_var;
                start <= '1', '0' after c_period;
                wait until ready='1';
                rotate_by_cordic(vector_mode, x_coord_var, y_coord_var, angle_in, angle_out, x_coord_out, y_coord_out);
                delta_angle  := rotation_angle  - angle_out;
                delta_length := x_coord_rotated - x_coord_out;
                if delta_angle/=0 or delta_length/=0 then
                    --report "delta_angle  = " & to_hstring(delta_angle);
                    --report "delta_length = " & to_hstring(delta_length);
                end if;
                if delta_angle<0 then
                    delta_angle := - delta_angle;
                end if;
                delta_angle_sum := delta_angle_sum + delta_angle;
                if delta_angle>delta_angle_max then
                    delta_angle_max := delta_angle;
                end if;
                if delta_length<0 then
                    delta_length := - delta_length;
                end if;
                delta_length_sum := delta_length_sum + delta_length;
                if delta_length>delta_length_max then
                    delta_length_max := delta_length;
                end if;
                x_coord_var := x_coord_var + signed(increment);
                wait for c_period/10;
                wait for c_period;
            end loop;
            -- Case 3
            report "case3";
            x_coord_var                   := (others => '0');
            x_coord_var(x_coord_var'high) := '1';
            x_coord_var                   := shift_right(x_coord_var, shift_number);
            x_coord <= x_coord_var;
            y_coord_var                   := (others => '0');
            y_coord_var(y_coord'high)     := '1';
            y_coord_var                   := shift_right(y_coord_var, shift_number);
            for i in 0 to steps-1 loop
                y_coord <= y_coord_var;
                start <= '1', '0' after c_period;
                wait until ready='1';
                rotate_by_cordic(vector_mode, x_coord_var, y_coord_var, angle_in, angle_out, x_coord_out, y_coord_out);
                delta_angle  := rotation_angle  - angle_out;
                delta_length := x_coord_rotated - x_coord_out;
                if delta_angle/=0 or delta_length/=0 then
                    --report "delta_angle  = " & to_hstring(delta_angle);
                    --report "delta_length = " & to_hstring(delta_length);
                end if;
                if delta_angle<0 then
                    delta_angle := - delta_angle;
                end if;
                delta_angle_sum := delta_angle_sum + delta_angle;
                if delta_angle>delta_angle_max then
                    delta_angle_max := delta_angle;
                end if;
                if delta_length<0 then
                    delta_length := - delta_length;
                end if;
                delta_length_sum := delta_length_sum + delta_length;
                if delta_length>delta_length_max then
                    delta_length_max := delta_length;
                end if;
                y_coord_var := y_coord_var + signed(increment);
                wait for c_period/10;
                wait for c_period;
            end loop;
            -- Case 4
            report "case4";
            y_coord_var                   := (others => '0');
            y_coord_var(x_coord_var'high) := '1';
            y_coord_var                   := shift_right(y_coord_var, shift_number);
            y_coord <= y_coord_var;
            x_coord_var                   := (others => '0');
            x_coord_var(x_coord'high)     := '1';
            x_coord_var                   := shift_right(x_coord_var, shift_number);
            for i in 0 to steps-1 loop
                x_coord <= x_coord_var;
                start <= '1', '0' after c_period;
                wait until ready='1';
                rotate_by_cordic(vector_mode, x_coord_var, y_coord_var, angle_in, angle_out, x_coord_out, y_coord_out);
                delta_angle  := rotation_angle  - angle_out;
                delta_length := x_coord_rotated - x_coord_out;
                if delta_angle/=0 or delta_length/=0 then
                    --report "delta_angle  = " & to_hstring(delta_angle);
                    --report "delta_length = " & to_hstring(delta_length);
                end if;
                if delta_angle<0 then
                    delta_angle := - delta_angle;
                end if;
                delta_angle_sum := delta_angle_sum + delta_angle;
                if delta_angle>delta_angle_max then
                    delta_angle_max := delta_angle;
                end if;
                if delta_length<0 then
                    delta_length := - delta_length;
                end if;
                delta_length_sum := delta_length_sum + delta_length;
                if delta_length>delta_length_max then
                    delta_length_max := delta_length;
                end if;
                x_coord_var := x_coord_var + signed(increment);
                wait for c_period/10;
                wait for c_period;
            end loop;
            report lf &
                    "shiftnummer             = " & integer'image(shift_number)  & lf &
                    "number of bits at angle = " & integer'image(c_angle_width) & lf &
                    "Maximum difference between calculated angle  and reference = " & integer'image(integer(signed_to_real(delta_angle_max , true))) & lf &
                    "Maximum difference between calculated length and reference = " & integer'image(integer(signed_to_real(delta_length_max, true))) & lf &
                    "Sum of all angle differences                               = " & integer'image(integer(signed_to_real(delta_angle_sum , true))) & lf &
                    "Sum of all length differences                              = " & integer'image(integer(signed_to_real(delta_length_sum, true)));
        end loop; -- over shift_number
        run_simulation <= '0';
        wait;
    end process;
end architecture;
