-- Filename: rotate_shorten_vector_struct.vhd
-- Created by HDL-SCHEM-Editor at Sun Mar 10 11:18:08 2024
architecture struct of rotate_shorten_vector is
begin
    shift_comb_g: if g_latency_shorten_vector=0 generate 
        ready_o   <= start_i;
        x_coord_o <= shift_right(x_coord_i, shift_nr_i);
        y_coord_o <= shift_right(y_coord_i, shift_nr_i);
    end generate shift_comb_g;
    shift_reg_g: if g_latency_shorten_vector/=0 generate 
        process(res_i, clk_i)
        begin
            if res_i='1' then
                ready_o   <= '0';
                x_coord_o <= (others => '0');
                y_coord_o <= (others => '0');
            elsif rising_edge(clk_i) then
                ready_o   <= start_i;
                x_coord_o <= shift_right(x_coord_i, shift_nr_i);
                y_coord_o <= shift_right(y_coord_i, shift_nr_i);
            end if;
        end process;
    end generate shift_reg_g;
end architecture;
