-- Filename: rotate_by_cordic_step_e.vhd
-- Created by HDL-SCHEM-Editor at Sun Mar 10 11:18:05 2024
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity rotate_by_cordic_step is
    generic (
        constant g_number_of_iterations     : natural := 32;
        constant g_number_of_iterations_all : natural := 32;
        constant g_angle_width              : natural := 32;
        constant g_coordinate_width         : natural := 32
    );
    port (
        positive_rotation_i : in  std_logic;
        rotation_angle_i    : in  signed(g_angle_width-1 downto 0);
        step_i              : in  natural range 0 to g_number_of_iterations_all-1;
        x_coord_i           : in  signed(g_coordinate_width+1 downto 0);
        y_coord_i           : in  signed(g_coordinate_width+1 downto 0);
        rotation_angle_o    : out signed(g_angle_width-1 downto 0);
        x_coord_o           : out signed(g_coordinate_width+1 downto 0);
        y_coord_o           : out signed(g_coordinate_width+1 downto 0)
    );
end entity rotate_by_cordic_step;
