-- Filename: rotate_by_cordic_e.vhd
-- Created by HDL-SCHEM-Editor at Fri Oct 18 14:30:42 2024
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity rotate_by_cordic is
    generic (
        constant g_coordinate_width     : natural := 18;
        constant g_angle_width          : natural := 18;
        constant g_latency              : natural := 18;
        constant g_improved_accuracy    : boolean := true
    );
    port (
        clk_i            : in  std_logic;
        res_i            : in  std_logic;
        rotation_angle_i : in  signed(g_angle_width-1 downto 0);
        start_cordic_i   : in  std_logic;
        vector_mode_i    : in  std_logic;
        x_coord_i        : in  signed(g_coordinate_width downto 0);
        y_coord_i        : in  signed(g_coordinate_width downto 0);
        ready_cordic_o   : out std_logic;
        rotation_angle_o : out signed(g_angle_width-1 downto 0);
        x_coord_o        : out signed(g_coordinate_width+1 downto 0);
        y_coord_o        : out signed(g_coordinate_width+1 downto 0)
    );
end entity rotate_by_cordic;
