-- Filename: rotate_lengthen_vector_struct.vhd
-- Created by HDL-SCHEM-Editor at Sun Mar 10 11:18:08 2024
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
architecture struct of rotate_lengthen_vector is
    function determine_index_of_lowest_sign_bit (signal coordinate_i : in signed) return natural is
        variable index_of_lowest_sign_bit : natural;
    begin
        index_of_lowest_sign_bit := 0;
        for i in 0 to coordinate_i'high-1 loop
            if (coordinate_i(i)/=coordinate_i(g_coordinate_width-1)) then
                -- If the bit is different from the leftmost bit,
                -- then the next bit could possibly be a signbit:
                index_of_lowest_sign_bit := i + 1;
            end if;
        end loop;
        return index_of_lowest_sign_bit;
    end function;
    signal lowest_sign_bit      : natural range 0 to g_coordinate_width-1;
    signal lowest_sign_bit_of_x : natural range 0 to g_coordinate_width-1;
    signal lowest_sign_bit_of_y : natural range 0 to g_coordinate_width-1;
    signal shift_nr             : natural range 0 to g_coordinate_width-1;
begin
    lowest_sign_bit_of_x <= determine_index_of_lowest_sign_bit(x_coord_i);
    lowest_sign_bit_of_y <= determine_index_of_lowest_sign_bit(y_coord_i);
    lowest_sign_bit <= lowest_sign_bit_of_x when lowest_sign_bit_of_x>lowest_sign_bit_of_y else
                       lowest_sign_bit_of_y;
    shift_nr <= g_coordinate_width - 1 - lowest_sign_bit;
    shift_comb_g: if g_latency_lengthen_vector=0 generate 
        x_coord_o  <= shift_left(x_coord_i, shift_nr);
        y_coord_o  <= shift_left(y_coord_i, shift_nr);
        shift_nr_o <= shift_nr;
        ready_o    <= start_i;
    end generate shift_comb_g;
    shift_reg_g: if g_latency_lengthen_vector/=0 generate 
        process(res_i, clk_i)
        begin
            if res_i='1' then
                x_coord_o  <= (others => '0');
                y_coord_o  <= (others => '0');
                shift_nr_o <= 0;
                ready_o    <= '0';
            elsif rising_edge(clk_i) then
                x_coord_o  <= shift_left(x_coord_i, shift_nr);
                y_coord_o  <= shift_left(y_coord_i, shift_nr);
                shift_nr_o <= shift_nr;
                ready_o    <= start_i;
            end if;
        end process;
    end generate shift_reg_g;
end architecture;
