-- Filename: rotate_struct.vhd
-- Created by HDL-SCHEM-Editor at Tue Mar 12 13:17:36 2024
architecture struct of rotate is
    signal ready_cordic         : std_logic;
    signal ready_fix            : std_logic;
    signal ready_rotation_by_90 : std_logic;
    signal ready_shift          : std_logic;
    signal rotation_angle       : signed(g_angle_width-1 downto 0);
    signal shift_nr             : natural range 0 to g_coordinate_width-1;
    signal x_coord              : signed(g_coordinate_width+1 downto 0);
    signal x_coord_fixed        : signed(g_coordinate_width downto 0);
    signal x_coord_rotated      : signed(g_coordinate_width downto 0);
    signal x_coord_shifted      : signed(g_coordinate_width-1 downto 0);
    signal y_coord              : signed(g_coordinate_width+1 downto 0);
    signal y_coord_fixed        : signed(g_coordinate_width downto 0);
    signal y_coord_rotated      : signed(g_coordinate_width downto 0);
    signal y_coord_shifted      : signed(g_coordinate_width-1 downto 0);
    component rotate_by_90 is
        generic (
            constant g_latency          : natural := 1; -- allowed range: [0..1]
            constant g_coordinate_width : natural := 8;
            constant g_angle_width      : natural := 4
        );
        port (
            clk_i             : in  std_logic;
            res_i             : in  std_logic;
            rotation_angle_i  : in  signed(g_angle_width-1 downto 0);
            start_i           : in  std_logic;
            vector_mode_i     : in  std_logic;
            x_coord_i         : in  signed(g_coordinate_width-1 downto 0);
            y_coord_i         : in  signed(g_coordinate_width-1 downto 0);
            ready_o           : out std_logic;
            rotation_angle_o  : out signed(g_angle_width-1 downto 0);
            x_coord_rotated_o : out signed(g_coordinate_width downto 0);
            y_coord_rotated_o : out signed(g_coordinate_width downto 0)
        );
    end component;
    component rotate_by_cordic is
        generic (
            constant g_coordinate_width     : natural := 18;
            constant g_angle_width          : natural := 18;
            constant g_latency              : natural := 18;
            constant g_improved_accuracy    : boolean := true
        );
        port (
            clk_i            : in  std_logic;
            res_i            : in  std_logic;
            rotation_angle_i : in  signed(g_angle_width-1 downto 0);
            start_cordic_i   : in  std_logic;
            vector_mode_i    : in  std_logic;
            x_coord_i        : in  signed(g_coordinate_width downto 0);
            y_coord_i        : in  signed(g_coordinate_width downto 0);
            ready_cordic_o   : out std_logic;
            rotation_angle_o : out signed(g_angle_width-1 downto 0);
            x_coord_o        : out signed(g_coordinate_width+1 downto 0);
            y_coord_o        : out signed(g_coordinate_width+1 downto 0)
        );
    end component;
    component rotate_fix_cordic_length is
        generic (
            constant g_latency          : natural := 1; -- allowed values: 0,1
            constant g_coordinate_width : natural := 16
        );
        port (
            clk_i       : in  std_logic;
            res_i       : in  std_logic;
            start_fix_i : in  std_logic;
            x_coord_i   : in  signed(g_coordinate_width+1 downto 0);
            y_coord_i   : in  signed(g_coordinate_width+1 downto 0);
            ready_fix_o : out std_logic;
            x_coord_o   : out signed(g_coordinate_width downto 0);
            y_coord_o   : out signed(g_coordinate_width downto 0)
        );
    end component;
    component rotate_lengthen_vector is
        generic (
            constant g_coordinate_width        : natural := 32;
            constant g_latency_lengthen_vector : natural := 0
        );
        port (
            clk_i      : in  std_logic;
            res_i      : in  std_logic;
            start_i    : in  std_logic;
            x_coord_i  : in  signed(g_coordinate_width-1 downto 0);
            y_coord_i  : in  signed(g_coordinate_width-1 downto 0);
            ready_o    : out std_logic;
            shift_nr_o : out natural range 0 to g_coordinate_width-1;
            x_coord_o  : out signed(g_coordinate_width-1 downto 0);
            y_coord_o  : out signed(g_coordinate_width-1 downto 0)
        );
    end component;
    component rotate_shorten_vector is
        generic (
            constant g_coordinate_width : natural := 32;
            constant g_latency_shorten_vector : natural := 0
        );
        port (
            clk_i      : in  std_logic;
            res_i      : in  std_logic;
            shift_nr_i : in  natural range 0 to g_coordinate_width-1;
            start_i    : in  std_logic;
            x_coord_i  : in  signed(g_coordinate_width downto 0);
            y_coord_i  : in  signed(g_coordinate_width downto 0);
            ready_o    : out std_logic;
            x_coord_o  : out signed(g_coordinate_width downto 0);
            y_coord_o  : out signed(g_coordinate_width downto 0)
        );
    end component;
begin
    -- Increase the accuracy by lengthening of the incoming vector.
    -- The vector coordinates are shifted to the left as much as possible:
    rotate_lengthen_vector_inst : rotate_lengthen_vector
        generic map (
            g_coordinate_width        => g_coordinate_width,
            g_latency_lengthen_vector => g_latency_lengthen_vector
        )
        port map (
            clk_i      => clk_i,
            res_i      => res_i,
            start_i    => start_i,
            x_coord_i  => x_coord_i,
            y_coord_i  => y_coord_i,
            ready_o    => ready_shift,
            shift_nr_o => shift_nr,
            x_coord_o  => x_coord_shifted,
            y_coord_o  => y_coord_shifted
        );
    -- rotate_by_90 rotates all vectors in the first and fourth quadrant,
    -- because only there the cordic algorithm converges.
    -- rotate_by_90 increases the number of bits of the coordinates by 1.
    -- This is necessary when the smallest negative number "1000...0" must be converted into a positive number.
    rotate_by_90_inst : rotate_by_90
        generic map (
            g_latency          => g_latency_rotate_by_90, -- allowed range: [0..1]
            g_coordinate_width => g_coordinate_width,
            g_angle_width      => g_angle_width
        )
        port map (
            clk_i             => clk_i,
            res_i             => res_i,
            rotation_angle_i  => rotation_angle_i,
            start_i           => ready_shift,
            vector_mode_i     => vector_mode_i,
            x_coord_i         => x_coord_shifted,
            y_coord_i         => y_coord_shifted,
            ready_o           => ready_rotation_by_90,
            rotation_angle_o  => rotation_angle,
            x_coord_rotated_o => x_coord_rotated,
            y_coord_rotated_o => y_coord_rotated
        );
    -- rotate_by_cordic increases the number of bits of the coordinates by 1.
    -- This is necessary because of 2 reasons:
    -- 1. The cos(phi) factors of the cordic algorithm are ignored inside rotate_by_cordic
    --    which produces a result which is too big by factor 1.607..
    -- 2. When the vector with the maximum positive x-coordinate and the maximum positive
    --    y-coordinate is rotated to the x-axis, its y-coordinate changes to 0 but its
    --    x-coordinate is exceeded by factor 1.41..
    -- The resulting factor of 1.607*1.41=2.26 causes the need of 2 additional bits for the coordinates.
    -- But as rotate_by_90 already has added 1 bit (without increasing the length of the vector),
    -- here only the second additional bit has to be added.
    rotate_by_cordic_inst : rotate_by_cordic
        generic map (
            g_coordinate_width  => g_coordinate_width,
            g_angle_width       => g_angle_width,
            g_latency           => g_latency_rotate_by_cordic,
            g_improved_accuracy => g_improved_accuracy
        )
        port map (
            clk_i            => clk_i,
            res_i            => res_i,
            rotation_angle_i => rotation_angle,
            start_cordic_i   => ready_rotation_by_90,
            vector_mode_i    => vector_mode_i,
            x_coord_i        => x_coord_rotated,
            y_coord_i        => y_coord_rotated,
            ready_cordic_o   => ready_cordic,
            rotation_angle_o => rotation_angle_o,
            x_coord_o        => x_coord,
            y_coord_o        => y_coord
        );
    -- rotate_fix_cordic length reduces the length of the rotated
    -- vector to its correct length by use of a factor 1/1.607=0.622.
    -- So the remaining increasement factor is 1.41, which means
    -- the outgoing coordinates have 1 bit more than the incoming.
    -- So 1 bit can be removed from the coordinates here.
    rotate_fix_cordic_length_inst : rotate_fix_cordic_length
        generic map (
            g_latency          => g_latency_fix_cordic_length, -- allowed values: 0,1
            g_coordinate_width => g_coordinate_width
        )
        port map (
            clk_i       => clk_i,
            res_i       => res_i,
            start_fix_i => ready_cordic,
            x_coord_i   => x_coord,
            y_coord_i   => y_coord,
            ready_fix_o => ready_fix,
            x_coord_o   => x_coord_fixed,
            y_coord_o   => y_coord_fixed
        );
    -- Reduce the vector length by using the number of shifts, which
    -- were introduced by the lengthening of the incoming vector:
    rotate_shorten_vector_inst : rotate_shorten_vector
        generic map (
            g_coordinate_width       => g_coordinate_width,
            g_latency_shorten_vector => g_latency_shorten_vector
        )
        port map (
            clk_i      => clk_i,
            res_i      => res_i,
            shift_nr_i => shift_nr,
            start_i    => ready_fix,
            x_coord_i  => x_coord_fixed,
            y_coord_i  => y_coord_fixed,
            ready_o    => ready_o,
            x_coord_o  => x_coord_o,
            y_coord_o  => y_coord_o
        );
end architecture;
