-- Filename: testbench_multiply_wt_booth_struct.vhd
-- Created by HDL-SCHEM-Editor at Wed Jul 16 16:11:41 2025
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
architecture struct of testbench_multiply_wt_booth is
    constant c_period : time := 10 ns;
    constant c_multiplicand_width      : positive :=  7;
    constant c_multiplier_width        : positive :=  5;
    constant c_latency_steps           : natural  :=  0;
    constant c_latency_addition        : natural  :=  0;
    signal clk            : std_logic := '0';
    signal multiplicand   : signed(c_multiplicand_width downto 0);
    signal multiplier     : signed(c_multiplier_width downto 0);
    signal product        : signed(c_multiplicand_width+c_multiplier_width-1 downto 0);
    signal ready          : std_logic;
    signal res            : std_logic;
    signal run_simulation : std_logic := '1';
    signal start          : std_logic;
    component multiply_wt_booth is
        generic (
            constant g_multiplicand_width      : positive := 32; -- allowed values: 2..
            constant g_multiplier_width        : positive := 32; -- allowed values: 2..
            constant g_latency_steps           : natural  :=  1; -- allowed values: all
            constant g_latency_addition        : natural  :=  0  -- allowed values: 0,1
        );
        port (
            clk_i          : in  std_logic ;
            multiplicand_i : in  signed (g_multiplicand_width-1 downto 0);
            multiplier_i   : in  signed (g_multiplier_width-1 downto 0);
            res_i          : in  std_logic ;
            start_i        : in  std_logic ;
            product_o      : out signed (g_multiplicand_width+g_multiplier_width-1 downto 0);
            ready_o        : out std_logic 
        );
    end component;
begin
    res <= '1', '0' after 1 ns;
    process
    begin
        while run_simulation='1' loop
            clk <= not clk;
            wait for c_period/2;
        end loop;
        wait;
    end process;
    process
    begin
        run_simulation <= '1';
        multiplicand <= (others => '0');
        multiplier   <= (others => '0');
        start <= '0';
        wait for c_period;
        wait for 1 ns;
    
        while multiplicand(multiplicand'high)/='1' loop
            while multiplier(multiplier'high)/='1' loop
                start <= '1', '0' after c_period;
                wait until rising_edge(clk);
                while ready/='1' loop
                    wait for c_period;
                end loop;
                assert product=(multiplicand(c_multiplicand_width-1 downto 0)*multiplier(c_multiplier_width-1 downto 0))
                       report "Error: product is wrong" severity warning;
                wait for 1 ns;
                start <= '0';
                wait for c_period;
                multiplier <= multiplier + 1;
            end loop;
            multiplier <= (others => '0');
            multiplicand <= multiplicand + 1;
            wait for c_period;
        end loop;
        run_simulation <= '0';
        wait;
    end process;
    multiply_wt_booth_inst : multiply_wt_booth
        generic map (
            g_multiplicand_width      => c_multiplicand_width,      -- allowed values: 2..
            g_multiplier_width        => c_multiplier_width,        -- allowed values: 2..
            g_latency_steps           => c_latency_steps,           -- allowed values: all
            g_latency_addition        => c_latency_addition         -- allowed values: 0,1
        )
        port map (
            clk_i          => clk,
            multiplicand_i => multiplicand(c_multiplicand_width-1 downto 0),
            multiplier_i   => multiplier(c_multiplier_width-1 downto 0),
            res_i          => res,
            start_i        => start,
            product_o      => product,
            ready_o        => ready
        );
end architecture;
