-- Filename: testbench_multiply_wt_booth_synthesis_struct.vhd
-- Created by HDL-SCHEM-Editor at Mon Jun 30 09:36:46 2025
architecture struct of testbench_multiply_wt_booth_synthesis is
    signal multiplicand : signed (g_multiplicand_width-1 downto 0);
    signal multiplier   : signed (g_multiplier_width-1 downto 0);
    signal product      : signed (g_multiplicand_width+g_multiplier_width-1 downto 0);
    signal ready        : std_logic;
    signal start        : std_logic;
    component multiply_wt_booth is
        generic (
            constant g_multiplicand_width      : positive := 32; -- allowed values: 2..
            constant g_multiplier_width        : positive := 32; -- allowed values: 2..
            constant g_latency_steps           : natural  :=  1; -- allowed values: all
            constant g_latency_addition        : natural  :=  0  -- allowed values: 0,1
        );
        port (
            clk_i          : in  std_logic ;
            multiplicand_i : in  signed (g_multiplicand_width-1 downto 0);
            multiplier_i   : in  signed (g_multiplier_width-1 downto 0);
            res_i          : in  std_logic ;
            start_i        : in  std_logic ;
            product_o      : out signed (g_multiplicand_width+g_multiplier_width-1 downto 0);
            ready_o        : out std_logic 
        );
    end component;
begin
    multiply_wt_booth_inst : multiply_wt_booth
        generic map (
            g_multiplicand_width      => g_multiplicand_width,      -- allowed values: 2..
            g_multiplier_width        => g_multiplier_width,        -- allowed values: 2..
            g_latency_steps           => g_latency_steps,           -- allowed values: all
            g_latency_addition        => g_latency_addition         -- allowed values: 0,1
        )
        port map (
            clk_i          => clk_i,
            multiplicand_i => multiplicand,
            multiplier_i   => multiplier,
            res_i          => res_i,
            start_i        => start,
            product_o      => product,
            ready_o        => ready
        );
    process(res_i, clk_i)
    begin
        if res_i='1' then
            multiplicand <= (others => '0');
            multiplier   <= (others => '0');
            start        <= '0';
        elsif rising_edge(clk_i) then
            multiplicand <= multiplicand_i;
            multiplier   <= multiplier_i;
            start        <= start_i;
        end if;
    end process;
    process(res_i, clk_i)
    begin
        if res_i='1' then
            product_o <= (others => '0');
            ready_o   <= '0';
        elsif rising_edge(clk_i) then
            product_o <= product;
            ready_o   <= ready;
        end if;
    end process;
end architecture;
