-- Filename: testbench_multiply_wt_booth_synthesis_e.vhd
-- Created by HDL-SCHEM-Editor at Mon Jun 30 09:36:46 2025
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity testbench_multiply_wt_booth_synthesis is
    generic (
        constant g_multiplicand_width         : natural := 48; -- Allowed values: 2..
        constant g_multiplier_width           : natural := 48; -- Allowed values: 2..
        constant g_latency_steps              : natural :=  0; -- Allowed values: all
        constant g_latency_addition           : natural :=  1  -- Allowed values: 0,1
    );
    port (
        clk_i          : in  std_logic;
        multiplicand_i : in  signed (g_multiplicand_width-1 downto 0);
        multiplier_i   : in  signed (g_multiplier_width-1 downto 0);
        res_i          : in  std_logic;
        start_i        : in  std_logic;
        product_o      : out signed (g_multiplicand_width+g_multiplier_width-1 downto 0);
        ready_o        : out std_logic
    );
end entity testbench_multiply_wt_booth_synthesis;
