-- Filename: multiply_wt_booth_step_e.vhd
-- Created by HDL-SCHEM-Editor at Tue Jul 15 10:29:49 2025
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.multiply_wt_booth_package.all;
entity multiply_wt_booth_step is
    generic (
        constant g_multiplicand_width       : natural := 16;
        constant g_multiplier_width         : natural := 6;
        constant g_multiplier_radix_4_width : natural := 3;
        constant g_number_of_rows           : natural := 4 -- Must be g_multiplier_radix_4_width+1 at the first step
    );
    port (
        sum_matrix_i : in  t_matrix(g_multiplier_radix_4_width downto 0)(g_multiplicand_width+g_multiplier_width-1 downto 0);
        sum_matrix_o : out t_matrix(g_multiplier_radix_4_width downto 0)(g_multiplicand_width+g_multiplier_width-1 downto 0)
    );
end entity multiply_wt_booth_step;
