-- Filename: multiply_wt_booth_partial_products_e.vhd
-- Created by HDL-SCHEM-Editor at Tue Jul 15 13:56:13 2025
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.multiply_wt_booth_package.all;
entity multiply_wt_booth_partial_products is
    generic (
        constant g_multiplicand_width       : natural := 16;
        constant g_multiplier_width         : natural := 6;
        constant g_multiplier_radix_4_width : natural := 3  -- must be g_multiplier_width/2 for even g_multiplier_width else (g_multiplier_width+1)/2
    );
    port (
        multiplicand_i       : in  signed(g_multiplicand_width-1 downto 0);
        multiplier_radix_4_i : in  t_signed3_array(g_multiplier_radix_4_width-1 downto 0);
        sign_of_multiplier_i : in  std_logic;
        partial_products_o   : out t_matrix(g_multiplier_radix_4_width downto 0)(g_multiplicand_width+g_multiplier_width-1 downto 0)
    );
end entity multiply_wt_booth_partial_products;
