-- Filename: multiply_wt_booth_partial_products_struct.vhd
-- Created by HDL-SCHEM-Editor at Tue Jul 15 13:56:13 2025
architecture struct of multiply_wt_booth_partial_products is
    signal multiplicand_ext : signed(g_multiplicand_width downto 0);
    signal multiplicand_neg : signed(g_multiplicand_width downto 0);
begin
    -- Increase the number of bits of the multiplicand by 1 in order to be able to negate the smallest negative multiplicand ("10..0"):
    multiplicand_ext <= resize(multiplicand_i, g_multiplicand_width+1);
    multiplicand_neg <= -multiplicand_ext;
    -- Create the matrix with all partial products:
    process(multiplicand_ext, multiplicand_neg, multiplier_radix_4_i, sign_of_multiplier_i)
        -- The size of the matrix with partial products is determined by:
        -- 1 row more, than multiplier bits exist, is needed here, because the last row is used to fix the result for negative multipliers.
        -- 1 column more, than the product will have bits, is needed here, because the multiplicand was extended by 1 bit (this additional
        -- column will only be used to insert multiplicand_neg into the last row without slicing):
        variable v_partial_products : t_matrix(g_multiplier_radix_4_width downto 0)(g_multiplicand_width+g_multiplier_width downto 0);
    begin
        -- Insert all the partial products between multiplicand_i and the digits of multiplier_radix_4_i at their correct position
        -- according to the weight and the value of the digit of multiplier_radix_4_i (with sign extension):
        v_partial_products := (others => (others => '0'));
        for row in 0 to g_multiplier_radix_4_width-1 loop
            case multiplier_radix_4_i(row) is
                when "010" =>
                    v_partial_products(row)(g_multiplicand_width+g_multiplier_width-1 downto 2*row+g_multiplicand_width+2) := (others => multiplicand_ext(g_multiplicand_width));
                    v_partial_products(row)(2*row+g_multiplicand_width+1 downto 2*row+1) := multiplicand_ext;
                when "001" =>
                    v_partial_products(row)(g_multiplicand_width+g_multiplier_width-1 downto 2*row+g_multiplicand_width+1) := (others => multiplicand_ext(g_multiplicand_width));
                    v_partial_products(row)(2*row+g_multiplicand_width   downto 2*row  ) := multiplicand_ext;
                when "111" =>
                    v_partial_products(row)(g_multiplicand_width+g_multiplier_width-1 downto 2*row+g_multiplicand_width+1) := (others => multiplicand_neg(g_multiplicand_width));
                    v_partial_products(row)(2*row+g_multiplicand_width   downto 2*row  ) := multiplicand_neg;
                when "110" =>
                    v_partial_products(row)(g_multiplicand_width+g_multiplier_width-1 downto 2*row+g_multiplicand_width+2) := (others => multiplicand_neg(g_multiplicand_width));
                    v_partial_products(row)(2*row+g_multiplicand_width+1 downto 2*row+1) := multiplicand_neg;
                when others =>
                    null;
            end case;
        end loop;
        if sign_of_multiplier_i='1' then
            -- Fix the wrong result caused by handling the negative multiplier as if it was a positive number.
            -- Insert the correction value (-multiplicand) into the last row of the matrix at the appropriate column:
            v_partial_products(g_multiplier_radix_4_width)(2*g_multiplier_radix_4_width+g_multiplicand_width-1 downto 2*g_multiplier_radix_4_width-1) := multiplicand_neg;
        end if;
        for i in 0 to g_multiplier_radix_4_width loop
            partial_products_o(i) <= v_partial_products(i)(g_multiplicand_width+g_multiplier_width-1 downto 0);
        end loop;
    end process;
end architecture;
