-- Filename: multiply_wt_step_e.vhd
-- Created by HDL-SCHEM-Editor at Fri Jun 27 11:33:07 2025
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.multiply_wt_package.all;
entity multiply_wt_step is
    generic (
        constant g_multiplicand_width : natural := 32;
        constant g_multiplier_width   : natural := 32;
        constant g_number_of_rows     : natural := g_multiplier_width+1 -- This value is used at a first step and will be reduced for the following steps.
    );
    port (
        sum_matrix_i : in  t_matrix(g_multiplier_width downto 0)(g_multiplicand_width+g_multiplier_width-1 downto 0);
        sum_matrix_o : out t_matrix(g_multiplier_width downto 0)(g_multiplicand_width+g_multiplier_width-1 downto 0)
    );
end entity multiply_wt_step;
