-- Filename: multiply_wt_step_struct.vhd
-- Created by HDL-SCHEM-Editor at Fri Jun 27 11:33:07 2025
library ieee;
use ieee.std_logic_1164.all;
architecture struct of multiply_wt_step is
begin
    process (sum_matrix_i)
        variable sum_tmp : signed(1 downto 0);
        variable number_of_adders : natural;
        variable number_of_spares : natural;
    begin
        -- Process one step by adding up the bits of all columns with full-adders with 3 inputs:
        number_of_adders := g_number_of_rows/3;
        number_of_spares := g_number_of_rows mod 3;
        sum_matrix_o <= (others => (others => '0'));
        for column in 0 to g_multiplicand_width+g_multiplier_width-1 loop
            for n in 0 to number_of_adders-1 loop -- implement the adders
                sum_tmp := ('0'&sum_matrix_i(3*n  )(column)) +
                           ('0'&sum_matrix_i(3*n+1)(column)) +
                           ('0'&sum_matrix_i(3*n+2)(column));
                -- Put the sum in this column:
                sum_matrix_o(2*n)(column) <= sum_tmp(0);
                -- Put the carry in the next column:
                if column/=g_multiplicand_width+g_multiplier_width-1 then -- The carry of the highest column is not needed.
                    sum_matrix_o(2*n+1)(column+1) <= sum_tmp(1);
                end if;
            end loop;
            for s in 0 to number_of_spares-1 loop -- Copy the spares behind the sums.
                sum_matrix_o(2*number_of_adders+s)(column) <= sum_matrix_i(3*number_of_adders+s)(column);
            end loop;
        end loop;
    end process;
end architecture;
