-- Filename: multiply_wt_partial_products_struct.vhd
-- Created by HDL-SCHEM-Editor at Fri Jun 27 11:34:21 2025
architecture struct of multiply_wt_partial_products is
begin
    -- An additional row needed in order to store the increment 1 of the 2's complement calculation of the multiplicand (for handling negative multipliers).
    process(multiplicand_i, multiplier_i)
        variable v_partial_products : t_matrix(g_multiplier_width downto 0)(g_multiplicand_width+g_multiplier_width-1 downto 0);
    begin
        -- Calculate all the partial products between multiplicand_i and the bits of multiplier_i and
        -- shift them to their correct position according to the weight of the bit of multiplier_i:
        v_partial_products := (others => (others => '0'));
        for row in 0 to g_multiplier_width-1 loop
            for column in 0 to g_multiplicand_width-1 loop
                if row/=g_multiplier_width-1 then -- all bits but the sign bit of multiplier_i
                    v_partial_products(row)(row+column) := multiplicand_i(column) and multiplier_i(row);
                else -- Sign bit of multiplier_i
                    -- Prepare the 2's complement calculation of the multiplicand at a negative multiplier:
                    v_partial_products(row)(row+column) := (not multiplicand_i(column)) and multiplier_i(row);
                end if;
            end loop;
            -- Sign extension is needed to be able to handle negative multiplicands:
            v_partial_products(row)(v_partial_products(row)'high downto row+g_multiplicand_width) := (others => v_partial_products(row)(row+g_multiplicand_width-1));
        end loop;
        -- Complete the 2's complement calculation of the multiplicand by adding 1:
        v_partial_products(g_multiplier_width) := (others => '0');
        v_partial_products(g_multiplier_width)(g_multiplier_width-1) := multiplier_i(multiplier_i'high);
        partial_products_o <= v_partial_products;
    end process;
end architecture;
