-- Filename: multiply_wt_e.vhd
-- Created by HDL-SCHEM-Editor at Fri Jun 27 11:38:58 2025
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity multiply_wt is
    generic (
        constant g_multiplicand_width      : positive := 32; -- Allowed values: 2..
        constant g_multiplier_width        : positive := 32; -- Allowed values: 2..
        constant g_latency_steps           : natural  :=  1; -- Allowed values: all
        constant g_latency_addition        : natural  :=  0  -- Allowed values: 0,1
    );
    port (
        clk_i          : in  std_logic;
        multiplicand_i : in  signed(g_multiplicand_width-1 downto 0);
        multiplier_i   : in  signed(g_multiplier_width-1 downto 0);
        res_i          : in  std_logic;
        start_i        : in  std_logic;
        product_o      : out signed(g_multiplicand_width+g_multiplier_width-1 downto 0);
        ready_o        : out std_logic
    );
end entity multiply_wt;
