-- Filename: testbench_multiply_sd_synthesis_e.vhd
-- Created by HDL-SCHEM-Editor at Fri May  9 09:42:38 2025
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity testbench_multiply_sd_synthesis is
    generic (
        constant g_multiplicand_width         : natural := 32; -- Allowed values: 2..
        constant g_multiplier_width           : natural := 32; -- Allowed values: 2..
        constant g_latency_mul                : natural :=  2; -- Allowed values: all
        constant g_latency_convert            : natural :=  0  -- Allowed values: 0,1
    );
    port (
        clk_i          : in  std_logic;
        multiplicand_i : in  signed (g_multiplicand_width-1 downto 0);
        multiplier_i   : in  signed (g_multiplier_width-1 downto 0);
        res_i          : in  std_logic;
        start_i        : in  std_logic;
        product_o      : out signed (g_multiplicand_width+g_multiplier_width-1 downto 0);
        ready_o        : out std_logic
    );
end entity testbench_multiply_sd_synthesis;
