-- Filename: multiply_sd_step_struct.vhd
-- Created by HDL-SCHEM-Editor at Fri Jun  6 15:58:06 2025
library ieee;
use ieee.std_logic_1164.all;
architecture struct of multiply_sd_step is
    signal multiplicand_mod    : t_sd_number(g_multiplicand_width_ext/2+1 downto 0);
    signal partial_product_ext : t_sd_number(g_multiplicand_width_ext/2+1 downto 0);
begin
    -- Extend the partial product by one digit. As the partial product represents a
    -- number in 2's complement, a sign extension must be done:
    partial_product_ext(g_multiplicand_width_ext/2 downto 0) <= partial_product_i;
    partial_product_ext(g_multiplicand_width_ext/2+1)        <= "000" when partial_product_i(g_multiplicand_width_ext/2)="000" else
                                                                "011";
    
    -- Extend the multiplicand for the addition and check for a negative multiplier:
    process (last_multiplier_bit_i, multiplier_bits_used_i,
             multiplicand_sd_3_i, multiplicand_sd_2_i, multiplicand_sd_1_i)
    begin
        case std_logic_vector'(multiplier_bits_used_i(1), multiplier_bits_used_i(0), last_multiplier_bit_i) is
            when "110"  => -- factor_bit_i is 3 (cannot be the last factor_bit_i).
                multiplicand_mod <= multiplicand_sd_3_i;
            when "100"  => -- factor_bit_i is 2 (cannot be the last factor_bit_i).
                multiplicand_mod <= multiplicand_sd_2_i;
            when "010"  => -- factor_bit_i is 1 and is not the last factor_bit_i.
                multiplicand_mod <= multiplicand_sd_1_i;
            when "011"  => -- factor_bit_i is 1 and is the last factor_bit_i.
                -- The multiplier is negative, this means the multiplicand must be subtracted:
                for i in multiplicand_sd_1_i'range loop
                    multiplicand_mod(i) <= - multiplicand_sd_1_i(i);
                end loop;
            when others => -- factor_bit_i is 0.
                multiplicand_mod <= (others => "000");
        end case;
    end process;
    partial_product_o <= partial_product_ext + multiplicand_mod;
end architecture;
