-- Filename: multiply_sd_prepare_struct.vhd
-- Created by HDL-SCHEM-Editor at Fri Jun  6 15:58:06 2025
architecture struct of multiply_sd_prepare is
    signal multiplicand_ext  : signed(g_multiplicand_width_ext-1 downto 0);
    signal multiplicand_sd_1 : t_sd_number(g_multiplicand_width_ext/2+1 downto 0);
    signal multiplicand_sd_2 : t_sd_number(g_multiplicand_width_ext/2+1 downto 0);
begin
    -- Increase the number of bits to a multiple of 2:
    multiplicand_ext <= resize(multiplicand_i, g_multiplicand_width_ext);
    -- Prepare handling 1 multiplier-digit (equals 2 multiplier-bits) by calculating the needed products of the multiplicand.
    -- Add at the same time an additional overflow digit:
    process (multiplicand_ext)
        variable multiplicand_ext_times_1 : signed(g_multiplicand_width_ext+3 downto 0);
        variable multiplicand_ext_times_2 : signed(g_multiplicand_width_ext+3 downto 0);
    begin
        multiplicand_ext_times_1 := (3 downto 0 => multiplicand_ext(multiplicand_ext'high)) & multiplicand_ext;
        multiplicand_ext_times_2 := (2 downto 0 => multiplicand_ext(multiplicand_ext'high)) & multiplicand_ext & '0';
        for i in 0 to g_multiplicand_width_ext/2+1 loop
            multiplicand_sd_1(i) <= '0' & multiplicand_ext_times_1(2*i+1 downto 2*i);
        end loop;
        for i in 0 to g_multiplicand_width_ext/2+1 loop
            multiplicand_sd_2(i) <= '0' & multiplicand_ext_times_2(2*i+1 downto 2*i);
        end loop;
    end process;
    -- Create outputs:
    multiplicand_sd_1_o <= multiplicand_sd_1;
    multiplicand_sd_2_o <= multiplicand_sd_2;
    multiplicand_sd_3_o <= multiplicand_sd_2 + multiplicand_sd_1;
    
end architecture;
