-- Filename: testbench_multiply_karatsuba_struct.vhd
-- Created by HDL-SCHEM-Editor at Mon Apr  8 08:54:29 2024
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
library work;
architecture struct of testbench_multiply_karatsuba is
    constant c_period : time := 10 ns;
    constant c_multiplicand_width : natural :=  4; -- 7; --9; --4;
    constant c_multiplier_width   : natural :=  7; --11; --4; --4;

    signal clk            : std_logic := '0';
    signal multiplicand   : signed(c_multiplicand_width-1 downto 0);
    signal multiplier     : signed(c_multiplier_width-1 downto 0);
    signal product        : signed(c_multiplicand_width+c_multiplier_width-1 downto 0);
    signal product_test   : signed(c_multiplicand_width+c_multiplier_width-1 downto 0);
    signal ready          : std_logic;
    signal res            : std_logic;
    signal run_simulation : std_logic := '1';
    signal start          : std_logic;
    component multiply_karatsuba is
        generic (
            constant g_multiplicand_width : natural := 16;
            constant g_multiplier_width   : natural := 16
        );
        port (
            clk_i          : in  std_logic;
            multiplicand_i : in  signed(g_multiplicand_width-1 downto 0);
            multiplier_i   : in  signed(g_multiplier_width-1 downto 0);
            res_i          : in  std_logic;
            start_i        : in  std_logic;
            product_o      : out signed(g_multiplicand_width+g_multiplier_width-1 downto 0);
            ready_o        : out std_logic
        );
    end component;
    for multiply_karatsuba_inst : multiply_karatsuba use entity work.multiply_karatsuba(mul_operator);
begin
    res <= '1', '0' after 1 ns;
    process
    begin
        while run_simulation='1' loop
            clk <= not clk;
            wait for c_period/2;
        end loop;
        wait;
    end process;
    process
        variable r : natural := 0;
        variable d : natural := 0;
    begin
        run_simulation <= '1';
        multiplicand <= (others => '0');
        multiplier   <= (others => '0');
        start <= '0';
        wait for c_period;
        wait for 1 ns;
    
        while d/=2**(multiplicand'length) loop
            while r/=2**(multiplier'length) loop
                start <= '1', '0' after c_period;
                wait until rising_edge(clk);
                while ready/='1' loop
                    wait for c_period;
                end loop;
                assert product=(multiplicand*multiplier) report "Error: product is wrong" severity error;
                wait for 1 ns;
                start <= '0';
                wait for c_period;
                multiplier <= multiplier + 1;
                r := r + 1;
            end loop;
            r := 0;
            multiplier <= (others => '0');
            multiplicand <= multiplicand + 1;
            d := d + 1;
        end loop;
        run_simulation <= '0';
        wait;
    end process;
    product_test <= multiplicand*multiplier;
    multiply_karatsuba_inst : multiply_karatsuba
        generic map (
            g_multiplicand_width => c_multiplicand_width,
            g_multiplier_width   => c_multiplier_width
        )
        port map (
            clk_i          => clk,
            multiplicand_i => multiplicand,
            multiplier_i   => multiplier,
            res_i          => res,
            start_i        => start,
            product_o      => product,
            ready_o        => ready
        );
end architecture;
