-- Filename: multiply_karatsuba_step_e.vhd
-- Created by HDL-SCHEM-Editor at Mon Apr  8 08:29:15 2024
-- The Karatsuba Multiplication is a recursive algorithm.
-- The operands must be positive and must have the same number of bits.
-- The number of bits must be a power of 2, as the operand width is halfed at each iteration.
-- As upper and lower half of the operands must be added, sums are created which have 1 additional overflow bit.
-- This bit must be handled separately, because the sums are connected to a next multiply_karatsuba module,
-- which can only handle power of 2 as operand width.
-- Handling these overflow bits creates additional adders (with many input bits at 0, but with a carry path).
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity multiply_karatsuba_step is
    generic (
        constant g_operand_width : natural := 16 -- must be a power of 2
    );
    port (
        factor_1_i : in  unsigned(g_operand_width-1 downto 0);
        factor_2_i : in  unsigned(g_operand_width-1 downto 0);
        product_o  : out unsigned(2*g_operand_width-1 downto 0)
    );
end entity multiply_karatsuba_step;
