-- Filename: multiply_karatsuba_struct.vhd
-- Created by HDL-SCHEM-Editor at Mon Apr  8 09:20:46 2024
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.math_real.all;
architecture struct of multiply_karatsuba is
    function determine_operand_width return natural is
        variable max_input_width : natural;
    begin
        if g_multiplicand_width>=g_multiplier_width then
            max_input_width := g_multiplicand_width;
        else
            max_input_width := g_multiplier_width;
        end if;
        return natural(2**ceil(log2(real(max_input_width))));
    end function;
    constant c_operand_width : natural := determine_operand_width;
    signal factor_1              : unsigned(c_operand_width-1 downto 0);
    signal factor_2              : unsigned(c_operand_width-1 downto 0);
    signal multiplicand          : unsigned(g_multiplicand_width-1 downto 0);
    signal multiplicand_positive : boolean;
    signal multiplier            : unsigned(g_multiplier_width-1 downto 0);
    signal multiplier_positive   : boolean;
    signal product               : signed(g_multiplicand_width+g_multiplier_width-1 downto 0);
    signal product_unsigned      : unsigned(2*c_operand_width-1 downto 0);
    component multiply_karatsuba_step is
        generic (
            constant g_operand_width : natural := 16 -- must be a power of 2
        );
        port (
            factor_1_i : in  unsigned(g_operand_width-1 downto 0);
            factor_2_i : in  unsigned(g_operand_width-1 downto 0);
            product_o  : out unsigned(2*g_operand_width-1 downto 0)
        );
    end component;
begin
    process(multiplicand_i)
        variable multiplicand_signed : signed(g_multiplicand_width downto 0);
    begin
        if multiplicand_i(multiplicand_i'high)='0' then
            multiplicand_signed   :=  resize(multiplicand_i, g_multiplicand_width+1);
            multiplicand_positive <= true;
        else
            multiplicand_signed   := -resize(multiplicand_i, g_multiplicand_width+1);
            multiplicand_positive <= false;
        end if;
        multiplicand <= unsigned(multiplicand_signed(g_multiplicand_width-1 downto 0));
    end process;
    process (multiplicand)
    begin
        factor_1 <= (others => '0');
        factor_1(g_multiplicand_width-1 downto 0) <= multiplicand;
    end process;
    process(multiplier_i)
        variable multiplier_signed : signed(g_multiplier_width downto 0);
    begin
        if multiplier_i(multiplier_i'high)='0' then
            multiplier_signed   :=  resize(multiplier_i, g_multiplier_width+1);
            multiplier_positive <= true;
        else
            multiplier_signed   := -resize(multiplier_i, g_multiplier_width+1);
            multiplier_positive <= false;
        end if;
        multiplier <= unsigned(multiplier_signed(g_multiplier_width-1 downto 0));
    end process;
    process (multiplier)
    begin
        factor_2 <= (others => '0');
        factor_2(g_multiplier_width-1 downto 0) <= multiplier;
    end process;
    multiply_karatsuba_step_inst : multiply_karatsuba_step
        generic map (
            g_operand_width => c_operand_width
        )
        port map (
            factor_1_i => factor_1,
            factor_2_i => factor_2,
            product_o  => product_unsigned
        );
    product <= signed('0' & product_unsigned(g_multiplicand_width+g_multiplier_width-2 downto 0))
               when multiplicand_positive=multiplier_positive else
              -signed('0' & product_unsigned(g_multiplicand_width+g_multiplier_width-2 downto 0));
    process (res_i, clk_i)
    begin
        if res_i='1' then
            ready_o   <= '0';
            product_o <= (others => '0');
        elsif rising_edge(clk_i) then
            ready_o <= start_i;
            if start_i='1' then
                product_o <= product;
            end if;
        end if;
    end process;
end architecture;
