-- Filename: testbench_multiply_cs_synthesis_e.vhd
-- Created by HDL-SCHEM-Editor at Mon Apr 28 11:40:55 2025
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity testbench_multiply_cs_synthesis is
    generic (
        constant g_multiplicand_width         : natural := 48; -- Allowed values: 2..
        constant g_multiplier_width           : natural := 48; -- Allowed values: 2..
        constant g_latency_mul                : natural :=  3; -- Allowed values: all
        constant g_latency_convert            : natural :=  1  -- Allowed values: 0,1
    );
    port (
        clk_i          : in  std_logic;
        multiplicand_i : in  signed (g_multiplicand_width-1 downto 0);
        multiplier_i   : in  signed (g_multiplier_width-1 downto 0);
        res_i          : in  std_logic;
        start_i        : in  std_logic;
        product_o      : out signed (g_multiplicand_width+g_multiplier_width-1 downto 0);
        ready_o        : out std_logic
    );
end entity testbench_multiply_cs_synthesis;
