library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

package multiply_cs_package is
    -- CS numbers have digits with the values "00", "01", "10", "11".
    -- They represent the sum calculated from 3 single bits.
    type t_cs_number is array (natural range <>) of unsigned(1 downto 0);

    function add_carry_save (l: t_cs_number; r: signed; ci: std_logic) return t_cs_number;

    function cs_to_unsigned(cs_number: t_cs_number) return unsigned;

end package;

package body multiply_cs_package is
    function add_carry_save (l: t_cs_number; r: signed; ci: std_logic) return t_cs_number is
        variable op1    : unsigned(1 downto 0);
        variable op2    : unsigned(1 downto 0);
        variable op3    : unsigned(1 downto 0);
        variable sum    : t_cs_number(l'range);
        variable result : t_cs_number(l'high downto 0);
    begin
        op1 := '0'&l(0)(0);
        op2 := '0'&r(0);
        op3 := '0'&ci;
        sum(0) := op1 + op2 + op3; -- 1 bit adder
        for i in 1 to l'high loop
            op1 := '0'&l(i)(0);
            op2 := '0'&r(i);
            op3 := '0'&l(i-1)(1);
            sum(i) := op1 + op2 + op3; -- 1 bit adder
        end loop;
        return sum;
    end function add_carry_save;

    function cs_to_unsigned(cs_number: t_cs_number) return unsigned is
        variable lower_bits  : unsigned(cs_number'range);
        variable higher_bits : unsigned(cs_number'range);
        variable result      : unsigned(cs_number'high+1 downto 0);
    begin
        for i in cs_number'range loop
            lower_bits(i)  := cs_number(i)(0);
            higher_bits(i) := cs_number(i)(1);
        end loop;
        result := higher_bits&'0' + lower_bits;
        return result(cs_number'range);
    end function;
end package body;
