-- Filename: multiply_cs_step_struct.vhd
-- Created by HDL-SCHEM-Editor at Fri Jun  6 15:57:26 2025
library ieee;
use ieee.std_logic_1164.all;
architecture struct of multiply_cs_step is
    signal carry_in            : std_logic;
    signal multiplicand_mod    : signed(g_multiplicand_width downto 0);
    signal partial_product_ext : t_cs_number(g_multiplicand_width downto 0);
begin
    -- Extend the partial product by one digit. As the partial product represents a
    -- number in 2's complement, a sign extension must be done:
    partial_product_ext(g_multiplicand_width-1 downto 0) <= partial_product_i;
    partial_product_ext(g_multiplicand_width)            <= '0'&partial_product_i(g_multiplicand_width-1)(0);
    -- Extend the multiplicand for the addition and check for a negative multiplier:
    process (last_multiplier_bit_i, factor_bit_i, multiplicand_i)
    begin
        case std_logic_vector'(factor_bit_i, last_multiplier_bit_i) is
            when "10"   => -- factor_bit_i is 1 and is not the last factor_bit_i.
                multiplicand_mod <= multiplicand_i(multiplicand_i'high)&multiplicand_i;
                carry_in         <= '0';
            when "11"   => -- factor_bit_i is 1 and is the last factor_bit_i.
                -- The multiplier is negative, this means the multiplicand must be subtracted:
                multiplicand_mod <= not (multiplicand_i(multiplicand_i'high) & multiplicand_i);
                carry_in         <= '1';
            when others => -- factor_bit_i is 0.
                multiplicand_mod <= (others => '0');
                carry_in         <= '0';
        end case;
    end process;
    partial_product_o <= add_carry_save(partial_product_ext, multiplicand_mod, carry_in);
end architecture;
