-- Filename: multiply_cs_convert_struct.vhd
-- Created by HDL-SCHEM-Editor at Fri Jun  6 15:57:26 2025
architecture struct of multiply_cs_convert is
begin
    combinatorial_g: if g_latency_convert=0 generate
        product_o <= signed(cs_to_unsigned(product_cs_i));
        ready_o   <= start_i;
    end generate combinatorial_g;
    clocked_g: if g_latency_convert/=0 generate
        process (res_i, clk_i)
        begin
            if res_i='1' then
                ready_o   <= '0';
                product_o <= (others => '0');
            elsif rising_edge(clk_i) then
                ready_o <= start_i;
                if start_i='1' then
                    product_o <= signed(cs_to_unsigned(product_cs_i));
                end if;
            end if;
        end process;
    end generate clocked_g;
end architecture;
