-- Filename: multiply_bsc_step_struct.vhd
-- Created by HDL-SCHEM-Editor at Thu May 15 17:31:06 2025
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
architecture struct of multiply_bsc_step is
    signal multiplicand_mod    : t_bsc_number(g_multiplicand_width downto 0);
    signal partial_product_ext : t_bsc_number(g_multiplicand_width downto 0);
begin
    -- Extend the partial product by one digit. As the partial product represents a
    -- number in 2's complement, a sign extension must be done:
    partial_product_ext(g_multiplicand_width-1 downto 0) <= partial_product_i;
    partial_product_ext(g_multiplicand_width)            <= '0'&partial_product_i(g_multiplicand_width-1)(0);
    process (factor_bit_i, last_multiplier_bit_i, multiplicand_neg_bsc_i, multiplicand_bsc_i)
    begin
        case std_logic_vector'(factor_bit_i, last_multiplier_bit_i) is
            when "10"   => -- factor_bit_i is 1 and is not the last factor_bit_i.
                multiplicand_mod <= multiplicand_bsc_i;
            when "11"   => -- factor_bit_i is 1 and is the last factor_bit_i.
                -- The multiplier is negative, this means the multiplicand must be subtracted:
                multiplicand_mod <= multiplicand_neg_bsc_i;
            when others => -- factor_bit_i is 0.
                multiplicand_mod <= (multiplicand_mod'range => "00");
        end case;
    end process;
    partial_product_o <= partial_product_ext + multiplicand_mod;
end architecture;
