library ieee;
use ieee.math_real.all;
-- Filename: multiply_bsc_negate_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Thu Apr 24 16:48:35 2025
architecture struct of multiply_bsc_negate is
begin
    -- The module multiply_bsc_step sometimes has to add the negated multiplicand.
    -- As the addition inside multiply_bsc_step works with BSC numbers, no simple negation as in 2's complement is available.
    -- So negation and also adding an additional bit (for carry out) is done here.
    -- As the negated multiplicand is only needed for the last multiplier bit, the negation can be implemented clocked,
    -- if latency is bigger than 1:
    neg_comb_g: if g_latency_mul=0 or g_latency_mul=1 generate
        multiplicand_neg <= -(multiplicand_i(g_multiplicand_width-1) & multiplicand_i);
    end generate neg_comb_g;
    neg_clocked_g: if g_latency_mul/=0 and g_latency_mul/=1 generate
        process (res_i, clk_i)
        begin
            if res_i='1' then
                multiplicand_neg <= (others => '0');
            elsif rising_edge(clk_i) then
                multiplicand_neg <= -(multiplicand_i(g_multiplicand_width-1) & multiplicand_i);
            end if;
        end process;
    end generate neg_clocked_g;
    process
    begin
        report "flipflop_statistics for instance " & multiply_bsc_negate'path_name & " signal multiplicand_neg generate-condition == " & boolean'image(( g_latency_mul/=0 and g_latency_mul/=1 ));
        report "flipflop_statistics for instance " & multiply_bsc_negate'path_name & " signal multiplicand_neg uses " & integer'image(multiplicand_neg'length) & " flipflops.";
        wait;
    end process;
end architecture;
