library ieee;
use ieee.math_real.all;
-- Filename: multiply_bsc_convert_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Mon Apr 28 10:50:41 2025
architecture struct of multiply_bsc_convert is
    signal product_out : signed(g_multiplicand_width+g_multiplier_width-1 downto 0);
begin
    product_o <= product_out(g_multiplicand_width+g_multiplier_width-1 downto 0);
    convert_comb_g: if g_latency_convert=0 generate
        product_out <= signed(bsc_to_unsigned(product_i));
        ready_o     <= start_i;
    end generate convert_comb_g;
    convert_clocked_g: if g_latency_convert/=0 generate
        process (res_i, clk_i)
        begin
            if res_i='1' then
                ready_o     <= '0';
                product_out <= (others => '0');
            elsif rising_edge(clk_i) then
                ready_o     <= start_i;
                product_out <= signed(bsc_to_unsigned(product_i));
            end if;
        end process;
    end generate convert_clocked_g;
    process
    begin
        report "flipflop_statistics for instance " & multiply_bsc_convert'path_name & " signal ready_o generate-condition == " & boolean'image(( g_latency_convert/=0 ));
        report "flipflop_statistics for instance " & multiply_bsc_convert'path_name & " signal ready_o uses 1 flipflop.";
        report "flipflop_statistics for instance " & multiply_bsc_convert'path_name & " signal product_out generate-condition == " & boolean'image(( g_latency_convert/=0 ));
        report "flipflop_statistics for instance " & multiply_bsc_convert'path_name & " signal product_out uses " & integer'image(product_out'length) & " flipflops.";
        wait;
    end process;
end architecture;
