library ieee;
use ieee.math_real.all;
-- Filename: multiply_bsc_step_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Mon Apr 28 10:49:46 2025
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
architecture struct of multiply_bsc_step is
    signal multiplicand_mod    : t_bsc_number(g_multiplicand_width downto 0);
    signal partial_product_ext : t_bsc_number(g_multiplicand_width downto 0);
begin
    -- The partial_product is shifted to the right outside of multiply_bsc_step.
    -- Therefore the multiplicand can be added to the partial_product without any shifting.
    -- But an additional digit is needed to store the carry.
    -- The additional digit of the multiplicand is added outside of multiply_bsc_step.
    -- The additional digit of partial_product is added here.
    -- As the value in partial_product_i represents a 2's complement number, its highest digit
    -- can only have the value "00" (positive number) or "01" (negative number).
    -- So adding an additional digit is done by:
    partial_product_ext(g_multiplicand_width-1 downto 0) <= partial_product_i;
    partial_product_ext(g_multiplicand_width)            <= '0'&partial_product_i(g_multiplicand_width-1)(0);
    process (factor_bit_i, last_multiplier_bit_i, multiplicand_neg_bsc_i, multiplicand_bsc_i)
    begin
        case std_logic_vector'(factor_bit_i, last_multiplier_bit_i) is
            when "11" =>
                multiplicand_mod <= multiplicand_neg_bsc_i;
            when "10" =>
                multiplicand_mod <= multiplicand_bsc_i;
            when others =>
                multiplicand_mod <= (multiplicand_mod'range => "00");
        end case;
    end process;
    partial_product_o <= partial_product_ext + multiplicand_mod;
    process
    begin
        report "flipflop_statistics for instance " & multiply_bsc_step'path_name & " no clocked signals found.";
        wait;
    end process;
end architecture;
