-- Filename: multiply_bsc_convert_struct.vhd
-- Created by HDL-SCHEM-Editor at Wed May 14 18:43:43 2025
architecture struct of multiply_bsc_convert is
begin
    convert_comb_g: if g_latency_convert=0 generate
        product_o <= signed(bsc_to_unsigned(product_i));
        ready_o     <= start_i;
    end generate convert_comb_g;
    convert_clocked_g: if g_latency_convert/=0 generate
        process (res_i, clk_i)
        begin
            if res_i='1' then
                ready_o     <= '0';
                product_o <= (others => '0');
            elsif rising_edge(clk_i) then
                ready_o     <= start_i;
                product_o <= signed(bsc_to_unsigned(product_i));
            end if;
        end process;
    end generate convert_clocked_g;
end architecture;
