-- Filename: multiply_e.vhd
-- Created by HDL-SCHEM-Editor at Fri May 16 09:23:34 2025
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity multiply is
    generic (
        constant g_multiplicand_width         : natural := 32;-- Allowed values: 2..
        constant g_multiplier_width           : natural := 32;-- Allowed values: 2..
        constant g_latency                    : natural :=  4 -- Allowed values: all
    );
    port (
        clk_i          : in  std_logic;
        multiplicand_i : in  signed(g_multiplicand_width-1 downto 0);
        multiplier_i   : in  signed(g_multiplier_width-1 downto 0);
        res_i          : in  std_logic;
        start_i        : in  std_logic;
        product_o      : out signed(g_multiplicand_width+g_multiplier_width-1 downto 0);
        ready_o        : out std_logic
    );
end entity multiply;
