-- Filename: multiply_step_struct.vhd
-- Created by HDL-SCHEM-Editor at Wed May 14 09:48:11 2025
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
architecture struct of multiply_step is
    signal multiplicand_mod    : signed(g_multiplicand_width downto 0);
    signal new_partial_product : signed(g_multiplicand_width downto 0);
    signal subtract            : natural range 0 to 1;
begin
    subtract <= 1 when last_multiplier_bit_i='1' and factor_bit_i='1' else 0;
    multiplicand_mod    <= not (resize(multiplicand_i, g_multiplicand_width+1)) when subtract=1 else
                               (resize(multiplicand_i, g_multiplicand_width+1));
    new_partial_product <= resize(partial_product_i, g_multiplicand_width+1) + multiplicand_mod + subtract;
    partial_product_o   <= new_partial_product when factor_bit_i='1' else
                           resize(partial_product_i, g_multiplicand_width+1);
end architecture;
