-- Filename: multiply_fpga.vhd
-- Created by HDL-SCHEM-Editor at Thu Apr  4 14:12:29 2024
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
architecture fpga of multiply is
    function calculate_number_of_periods return natural is
    begin
        if g_latency=0 then
            return 1;
        end if;
        return g_latency;
    end function;
    constant c_number_of_periods : natural := calculate_number_of_periods;

    signal last_step : std_logic;
    signal ready     : std_logic;
    component multiply_control is
        generic (
            g_counter_max : natural := 8
        );
        port (
            clk_i        : in  std_logic;
            res_i        : in  std_logic;
            start_i      : in  std_logic;
            last_step_o  : out std_logic;
            ready_o      : out std_logic;
            reg_enable_o : out std_logic
        );
    end component;
begin
    multiply_control_inst : multiply_control
        generic map (
            g_counter_max => c_number_of_periods-1
        )
        port map (
            clk_i        => clk_i,
            res_i        => res_i,
            start_i      => start_i,
            last_step_o  => last_step,
            ready_o      => ready,
            reg_enable_o => open
        );
    register_g: if g_latency/=0 generate 
        process(res_i, clk_i)
        begin
            if res_i='1' then
                product_o <= (others => '0');
            elsif rising_edge(clk_i) then
                if last_step='1' then
                    product_o <= multiplicand_i * multiplier_i;
                end if;
            end if;
        end process;
        ready_o <= ready;
    end generate register_g;
    combinatoric_g: if  g_latency=0 generate 
        product_o <= multiplicand_i * multiplier_i;
        ready_o <= start_i;
    end generate combinatoric_g;
end architecture;
