-- Filename: testbench_fifo_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Fri Mar 28 08:42:03 2025
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
architecture struct of testbench_fifo is
    constant c_period     : time    := 10 ns;
    constant c_fifo_depth : natural := 16;
    constant c_data_width : natural := 8;
    signal clk            : std_logic := '0';
    signal data_in        : std_logic_vector(c_data_width-1 downto 0);
    signal data_out       : std_logic_vector(c_data_width-1 downto 0);
    signal fifo_empty     : std_logic;
    signal fifo_full      : std_logic;
    signal fifo_overflow  : std_logic;
    signal fifo_underflow : std_logic;
    signal last           : std_logic;
    signal read_fifo      : std_logic;
    signal res            : std_logic;
    signal run_simulation : std_logic := '1';
    signal write_fifo     : std_logic;
    component fifo is
        generic (
            g_fifo_depth : natural := 8;
            g_data_width : natural := 16 
        );
        port (
            clk_i            : in  std_logic;
            data_i           : in  std_logic_vector(g_data_width-1 downto 0);
            read_fifo_i      : in  std_logic;
            res_i            : in  std_logic;
            write_fifo_i     : in  std_logic;
            data_o           : out std_logic_vector(g_data_width-1 downto 0);
            fifo_empty_o     : out std_logic;
            fifo_full_o      : out std_logic;
            fifo_overflow_o  : out std_logic;
            fifo_underflow_o : out std_logic;
            last_o           : out std_logic
        );
    end component;
begin
    res <= '1', '0' after 1 ns;
    process
    begin
        while run_simulation='1' loop
            clk <= not clk;
            wait for c_period/2;
        end loop;
        wait;
    end process;
    process
    begin
        run_simulation <= '1';
        write_fifo <= '0';
        read_fifo  <= '0';
        data_in <= (others => '0');
        wait for 1.1 * c_period;
        for i in 1 to 17 loop
            write_fifo <= '1', '0' after c_period;
            data_in <= std_logic_vector(to_unsigned(i, c_data_width));
            wait for c_period;
            if i=1 then
                assert last='1' report"Error: Output last=0" severity warning;
            else
                assert last='0' report"Error: Output last=1" severity warning;
            end if;
        end loop;
        wait for 5*c_period;
        for i in 1 to 17 loop
            if i<17 then
                assert to_integer(unsigned(data_out))=i report "Error at reading fifo" severity warning;
            end if;
            read_fifo <= '1', '0' after c_period;
            --data_in <= std_logic_vector(to_unsigned(i, c_data_width));
            wait for c_period;
            if i=15 then
                assert last='1' report"Error: Output last=0" severity warning;
            else
                assert last='0' report"Error: Output last=1" severity warning;
            end if;
        end loop;
        wait for 5*c_period;
        for i in 16 to 33 loop
            write_fifo <= '1', '0' after c_period;
            data_in <= std_logic_vector(to_unsigned(i, c_data_width));
            wait for c_period;
            assert to_integer(unsigned(data_out))=i report "Error at reading fifo" severity warning;
            assert last='1' report"Error: Output last=0" severity warning;
            read_fifo <= '1', '0' after c_period;
            wait for c_period;
            assert last='0' report"Error: Output last=1" severity warning;
        end loop;
        wait for 5*c_period;
        wait for 5*c_period;
        data_in <= std_logic_vector(to_unsigned(100, c_data_width));
        for i in 1 to 17 loop
            write_fifo <= '1', '0' after c_period;
            data_in <= std_logic_vector(to_unsigned(i, c_data_width));
            wait for c_period;
            if i=1 then
                assert last='1' report"Error: Output last=0" severity warning;
            else
                assert last='0' report"Error: Output last=1" severity warning;
            end if;
        end loop;
        wait for 5*c_period;
        wait for 5*c_period;
        for i in 1 to 17 loop
            if i<17 then
                assert to_integer(unsigned(data_out))=i report "Error at reading fifo" severity warning;
            end if;
            read_fifo <= '1', '0' after c_period;
            --data_in <= std_logic_vector(to_unsigned(i, c_data_width));
            wait for c_period;
            if i=15 then
                assert last='1' report"Error: Output last=0" severity warning;
            else
                assert last='0' report"Error: Output last=1" severity warning;
            end if;
        end loop;
        run_simulation <= '0';
        wait;
    end process;
    fifo_inst : fifo
        generic map (
            g_fifo_depth => c_fifo_depth,
            g_data_width => c_data_width
        )
        port map (
            clk_i            => clk,
            data_i           => data_in,
            read_fifo_i      => read_fifo,
            res_i            => res,
            write_fifo_i     => write_fifo,
            data_o           => data_out,
            fifo_empty_o     => fifo_empty,
            fifo_full_o      => fifo_full,
            fifo_overflow_o  => fifo_overflow,
            fifo_underflow_o => fifo_underflow,
            last_o           => last
        );
end architecture;
