-- Filename: fifo_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Thu Mar 27 17:45:04 2025
library ieee;
use ieee.math_real.all;
architecture struct of fifo is
    constant c_ram_address_width : natural := integer(ceil(log(real(g_fifo_depth))/log(2.0)));
    signal data_reg          : std_logic_vector(g_data_width-1 downto 0);
    signal fifo_empty        : std_logic;
    signal ram_address       : std_logic_vector(c_ram_address_width-1 downto 0);
    signal ram_data          : std_logic_vector(g_data_width-1 downto 0);
    signal select_ram_output : std_logic;
    signal write_ram         : std_logic;
    component fifo_control is
        generic (
            g_fifo_depth        : natural := 16;
            g_ram_address_width : natural := 4
        );
        port (
            clk_i            : in  std_logic;
            read_fifo_i      : in  std_logic;
            res_i            : in  std_logic;
            write_fifo_i     : in  std_logic;
            fifo_empty_o     : out std_logic;
            fifo_full_o      : out std_logic;
            fifo_overflow_o  : out std_logic;
            fifo_underflow_o : out std_logic;
            last_o           : out std_logic;
            ram_address_o    : out std_logic_vector(g_ram_address_width-1 downto 0);
            write_ram_o      : out std_logic
        );
    end component;
    component fifo_ram is
        generic (
            g_ram_address_width : natural := 8;
            g_data_width        : natural := 16 
        );
        port (
            clk_i         : in  std_logic;
            data_i        : in  std_logic_vector(g_data_width-1 downto 0);
            ram_address_i : in  std_logic_vector(g_ram_address_width-1 downto 0);
            write_ram_i   : in  std_logic;
            ram_data_o    : out std_logic_vector(g_data_width-1 downto 0)
        );
    end component;
    component fifo_data_reg is
        generic (
            constant g_data_width : natural := 8
        );
        port (
            clk_i               : in  std_logic;
            data_i              : in  std_logic_vector(g_data_width-1 downto 0);
            fifo_empty_i        : in  std_logic;
            ram_data_i          : in  std_logic_vector(g_data_width-1 downto 0);
            read_fifo_i         : in  std_logic;
            res_i               : in  std_logic;
            write_fifo_i        : in  std_logic;
            data_reg_o          : out std_logic_vector(g_data_width-1 downto 0);
            select_ram_output_o : out std_logic
        );
    end component;
begin
    fifo_control_inst : fifo_control
        generic map (
            g_fifo_depth        => g_fifo_depth,
            g_ram_address_width => c_ram_address_width
        )
        port map (
            clk_i            => clk_i,
            read_fifo_i      => read_fifo_i,
            res_i            => res_i,
            write_fifo_i     => write_fifo_i,
            fifo_empty_o     => fifo_empty,
            fifo_full_o      => fifo_full_o,
            fifo_overflow_o  => fifo_overflow_o,
            fifo_underflow_o => fifo_underflow_o,
            last_o           => last_o,
            ram_address_o    => ram_address,
            write_ram_o      => write_ram
        );
    fifo_empty_o <= fifo_empty;
    fifo_ram_inst : fifo_ram
        generic map (
            g_ram_address_width => c_ram_address_width,
            g_data_width        => g_data_width
        )
        port map (
            clk_i         => clk_i,
            data_i        => data_i,
            ram_address_i => ram_address,
            write_ram_i   => write_ram,
            ram_data_o    => ram_data
        );
    fifo_data_reg_inst : fifo_data_reg
        generic map (
            g_data_width => g_data_width
        )
        port map (
            clk_i               => clk_i,
            data_i              => data_i,
            fifo_empty_i        => fifo_empty,
            ram_data_i          => ram_data,
            read_fifo_i         => read_fifo_i,
            res_i               => res_i,
            write_fifo_i        => write_fifo_i,
            data_reg_o          => data_reg,
            select_ram_output_o => select_ram_output
        );
    -- ram_data is only for sure valid in the clock
    -- cycle directly after a read. Depending on the
    -- used RAM ram_data may change in all other clock
    -- cycles. Therefore the register data_reg keeps
    -- the data_o stable:
    data_o <= ram_data when select_ram_output='1' else
              data_reg;
end architecture;
