-- Filename: fifo_data_reg_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Thu Mar 27 18:18:03 2025
architecture struct of fifo_data_reg is
    signal select_ram_output : std_logic;
begin
    process(res_i, clk_i)
    begin
        if res_i='1' then
            select_ram_output <= '0';
            data_reg_o        <= (others => '0');
        elsif rising_edge(clk_i) then
            select_ram_output <= read_fifo_i;
            if write_fifo_i='1' and fifo_empty_i='1' then
                data_reg_o <= data_i; -- Store new written value.
            elsif select_ram_output='1' then
                data_reg_o <= ram_data_i; -- Store new read value.
            end if;
        end if;
    end process;
    select_ram_output_o <= select_ram_output;
end architecture;
