-- Filename: testbench_division_srt_radix2_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Fri Oct 18 15:37:11 2024
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
architecture struct of testbench_division_srt_radix2 is
    constant c_period : time := 10 ns;
    constant c_dividend_width   : natural := 5;
    constant c_divisor_width    : natural := 5;
    constant c_add_quotient_bits: natural := 0;
    constant c_latency_norm     : natural := 0;
    constant c_latency_division : natural := 1;
    constant c_latency_convert  : natural := 0;
    constant c_latency_denorm   : natural := 0;

    --                     1 2 3 4 5 6 7 8 9 10  -- c_dividend_width
    --                   1 0 0 0 0 0 0 0 0 0 0
    --                   2 0 0 0 0 0 0 0 0 0 0
    --                   3 0 0 x x x x x x x x    x = Configuration is allowed
    --                   4 0 0 x x x x x x x x    0 = Configuration is not allowed, division_srt_radix2 does not work.
    --                   5 0 0 x x x x x x x x
    --                   6 0 0 0 x x x x x x x
    --                   7 0 0 0 x x x x x x x
    --                   8 0 0 0 0 x x x x x x
    --                   9 0 0 0 0 x x x x x x
    --                  10 0 0 0 0 x x x x x x
    --                  11 0 0 0 0 x x x x x x
    --                  12 0 0 0 0 x x x x x x
    --                  13 0 0 0 0 x x x x x x
    --                  14 0 0 0 0 x x x x x x
    --                  15 0 0 0 0 x x x x x x
    --                 /
    -- c_divisor_width
    signal clk            : std_logic := '0';
    signal dividend       : signed(c_dividend_width-1 downto 0);
    signal divisor        : signed(c_divisor_width-1 downto 0);
    signal quotient       : signed(c_dividend_width+c_add_quotient_bits downto 0);
    signal ready          : std_logic;
    signal remainder      : signed(c_divisor_width-1 downto 0);
    signal res            : std_logic;
    signal run_simulation : boolean;
    signal start          : std_logic;
    component division_srt_radix2 is
        generic (
            constant g_dividend_width    : natural := 8;
            constant g_divisor_width     : natural := 8;
            constant g_add_quotient_bits : natural := 0;
            constant g_latency_division  : natural := 2;
            constant g_latency_convert   : natural := 0;
            constant g_latency_norm      : natural := 0;
            constant g_latency_denorm    : natural := 0 
        );
        port (
            clk_i      : in  std_logic;
            dividend_i : in  signed(g_dividend_width-1 downto 0);
            divisor_i  : in  signed(g_divisor_width-1 downto 0);
            res_i      : in  std_logic;
            start_i    : in  std_logic;
            quotient_o : out signed(g_dividend_width+g_add_quotient_bits downto 0);
            ready_o    : out std_logic;
            rem_o      : out signed(g_divisor_width-1 downto 0)
        );
    end component;
begin
    process
    begin
        res <= '1', '0' after 1 ns;
        wait for c_period;
        while run_simulation loop
            clk <= not clk;
            wait for c_period/2;
        end loop;
        wait;
    end process;
    process
        subtype range_of_dividend is integer range 2**(c_dividend_width-1)-1 downto -2**(c_dividend_width-1);
        subtype range_of_divisor  is integer range 2**(c_divisor_width -1)-1 downto -2**(c_divisor_width -1);
        variable number_of_divisions : natural := (range_of_dividend'high-range_of_dividend'low+1) *
                                                  (range_of_divisor'high-range_of_divisor'low);
        variable divisions_done : natural := 0;
        type real_array is array (natural range <>) of real;
        variable report_limits : real_array(0 to 18) := (0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09,
                                                         0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0);
        variable selected_report_limit : natural := 0;
    begin
        run_simulation <= true;
        start <= '0';
        dividend <= (others => '0');
        divisor  <= (others => '0');
        wait for c_period;
        wait for 1 ns;
        for dividend_int in range_of_dividend loop
        --for dividend_int in 2**(c_dividend_width-1)-1 downto 0 loop
        --for dividend_int in 12 downto 12 loop
            for divisor_int in 2**(c_divisor_width-1)-1 downto -2**(c_divisor_width-1) loop
            --for divisor_int in 2**(c_divisor_width-1)-1 downto 0 loop
            --for divisor_int in 3 downto 3 loop
                if divisor_int/=0 then
                    dividend <= to_signed(dividend_int, c_dividend_width);
                    divisor  <= to_signed(divisor_int , c_divisor_width );
                    start <= '1', '0' after c_period;
                    wait until rising_edge(clk);
                    while ready/='1' loop
                        wait for c_period;
                    end loop;
                    if   c_add_quotient_bits>0 then
                        -- Quotient mit Nachkommastellen
                        assert quotient =(resize(dividend, c_dividend_width+1)&(c_add_quotient_bits-1 downto 0 => '0'))/divisor
                            report "Wrong quotient with digits after binary point"  severity error; -- Resize is needed to avoid overflow at the division.
                    else
                        -- Integer Quotient
                        assert quotient =resize(dividend, c_dividend_width+1)/divisor
                            report "Wrong integer quotient"  severity error; -- Resize is needed to avoid overflow at the division.
                    end if;
                    assert remainder=dividend rem divisor report "Wrong remainder" severity error;
                    divisions_done := divisions_done + 1;
                    if real(divisions_done)/real(number_of_divisions)>report_limits(selected_report_limit) then
                        report integer'image(integer(100.0*report_limits(selected_report_limit))) & "% done";
                        selected_report_limit := selected_report_limit + 1;
                    end if;
                    wait for 1 ns;
                    wait for c_period;
                end if;
            end loop;
        end loop;
        run_simulation <= false;
        report "simulation stopped";
        wait;
    end process;
    
    division_srt_radix2_inst : division_srt_radix2
        generic map (
            g_dividend_width    => c_dividend_width,
            g_divisor_width     => c_divisor_width,
            g_add_quotient_bits => c_add_quotient_bits,
            g_latency_division  => c_latency_division,
            g_latency_convert   => c_latency_convert,
            g_latency_norm      => c_latency_norm,
            g_latency_denorm    => c_latency_denorm
        )
        port map (
            clk_i      => clk,
            dividend_i => dividend,
            divisor_i  => divisor,
            res_i      => res,
            start_i    => start,
            quotient_o => quotient,
            ready_o    => ready,
            rem_o      => remainder
        );
end architecture;
