-- Filename: division_srt_radix2_norm_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Tue Sep 17 15:24:02 2024
architecture struct of division_srt_radix2_norm is
    signal number_of_not_needed_sign_bits : natural range 0 to g_op_width-1;
    signal op_expanded                    : signed(g_op_width-1 downto 0);
    signal op_norm                        : signed(g_op_width-1 downto 0);
begin
    -- If necessary add signbits to increase the width:
    op_expanded <= resize(op_i, g_op_width);
    -- The normed operand shall have only 1 sign bit, so count the not needed ones:
    process(op_expanded)
        variable v_number_of_not_needed_sign_bits : natural range 0 to g_op_width-1;
    begin
        -- Count the number of not needed sign bits:
        v_number_of_not_needed_sign_bits := 0;
        for i in g_op_width-2 downto 0 loop
            if op_expanded(i)=op_expanded(g_op_width-1) then
                v_number_of_not_needed_sign_bits := v_number_of_not_needed_sign_bits + 1;
            else
                exit;
            end if;
        end loop;
        number_of_not_needed_sign_bits <= v_number_of_not_needed_sign_bits;
    end process;
    -- Bring the operands into the format "01..." or "10...":
    op_norm <= shift_left(op_expanded, number_of_not_needed_sign_bits);
    clocked_g: if g_latency/=0 generate
        process (res_i, clk_i)
        begin
            if res_i='1' then
                ready_norm_o       <= '0';
                op_norm_o          <= (others => '0');
                number_of_shifts_o <= 0;
            elsif rising_edge(clk_i) then
                ready_norm_o <= start_i;
                if start_i='1' then
                    op_norm_o          <= op_norm;
                    number_of_shifts_o <= number_of_not_needed_sign_bits;
                end if;
            end if;
        end process;
    end generate clocked_g;
    comb_g: if g_latency=0 generate
        ready_norm_o       <= start_i;
        op_norm_o          <= op_norm;
        number_of_shifts_o <= number_of_not_needed_sign_bits;
    end generate comb_g;
end architecture;
