-- Filename: division_srt_radix2_denorm_remainder_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Tue Sep 17 15:24:02 2024
architecture struct of division_srt_radix2_denorm_remainder is
    signal remainder              : signed(g_op_width-1 downto 0);
    signal remainder_norm_fixed_s : signed(g_op_width-1 downto 0);
begin
    clocked_g: if g_latency/=0 generate
        process (res_i, clk_i)
        begin
            if res_i='1' then
                remainder_norm_fixed_s <= (others => '0');
            elsif rising_edge(clk_i) then
                if start_i='1' then
                    remainder_norm_fixed_s <= remainder_norm_fixed_i;
                end if;
            end if;
        end process;
    end generate clocked_g;
    comb_g: if g_latency=0 generate
        remainder_norm_fixed_s <= remainder_norm_fixed_i;
    end generate comb_g;
    process (remainder_norm_fixed_s, remainder_too_big_by_shifts_i)
        variable op_pos_ext                  : signed  (g_op_width   downto 0);
        variable op_pos_ext_rounded_unsigned : unsigned(g_op_width   downto 0);
    begin
        if remainder_norm_fixed_s>=0 then
            remainder <= shift_right(remainder_norm_fixed_s, remainder_too_big_by_shifts_i);
        else
            -- Shifting of negative 2's complement numbers is not so straightforward, for example:
            -- When remainder_norm_fixed_s=1001=-7 and remainder_norm_fixed_s is shifted right by one we get remainder=1100=-4.
            -- But when we first convert remainder_norm_fixed_s to a positive number 0111=+7 and shift right by one we get 0011.
            -- When we convert back to a negative number we get remainder=1101=-3 which is different to -4 (see above).
            -- This problem occurs, because setting the least significant of a positive number to 0 reduces this number,
            -- while setting the least significant bit of a negative number to 0 increases its absolute value.
            -- This problem shows also when we shift remainder_norm_fixed_s=0001 right by one, which gives remainder=0000,
            -- but when we shift right remainder_norm_fixed_s=1111, we get remainder=1111.
            -- Therefore it is necessary to convert negative values of remainder_norm_fixed_s to positive ones before shifting.
            -- After shifting they must be converted back into negative numbers.
            op_pos_ext := - ('1' & remainder_norm_fixed_s);
            op_pos_ext_rounded_unsigned := unsigned(op_pos_ext); -- MSB is 0, because it is positive.
            remainder <= -signed(shift_right(op_pos_ext_rounded_unsigned(g_op_width-1 downto 0), remainder_too_big_by_shifts_i));
        end if;
    end process;
    
    rem_o <= remainder(g_divisor_width-1 downto 0);
end architecture;
