-- Filename: division_srt_radix2_denorm_struct.vhd.vhd
-- Created by HDL-SCHEM-Editor at Tue Sep 17 15:24:02 2024
architecture struct of division_srt_radix2_denorm is
    signal quotient : signed(g_op_width-1 downto 0);
begin
    process (quotient_norm_i, quotient_too_big_by_shifts_i)
        variable quotient_rounded_unsigned          : unsigned(g_op_width-1 downto 0);
        variable quotient_positive                  : signed  (g_op_width   downto 0);
        variable quotient_positive_rounded_unsigned : unsigned(g_op_width   downto 0);
    begin
        if quotient_norm_i>=0 then
            if quotient_norm_i(g_op_width-2 downto 0)=(g_op_width-2 downto 0 => '1') then
                -- The result before shift is +1.999999..., increase it to +2 (sign bit is used as data bit):
                quotient_rounded_unsigned := ('1', others => '0'); -- As '1' is a data bit, type unsigned must be used.
            else
                quotient_rounded_unsigned := unsigned(quotient_norm_i);
            end if;
            quotient <= signed(shift_right(quotient_rounded_unsigned, quotient_too_big_by_shifts_i));
        else
            -- Shifting of negative 2's complement numbers is not so straightforward, for example:
            -- When quotient_norm_i=1001=-7 and quotient_norm_i is shifted right by one we get quotient=1100=-4.
            -- But when we first convert quotient_norm_i to a positive number 0111=+7 and shift right by one we get 0011.
            -- When we convert back to a negative number we get quotient=1101=-3 which is different to -4 (see above).
            -- This problem occurs, because setting the least significant of a positive number to 0 reduces this number,
            -- while setting the least significant bit of a negative number to 0 increases its absolute value.
            -- This problem also shows when we shift quotient_norm_i=1111 right by one, which results in quotient=1111,
            -- but when we shift quotient_norm_i=0001 right by one, the result ist quotient=0000.
            -- Therefore it is necessary to convert negative values of quotient_norm_i to positive ones before shifting.
            -- After shifting they must be converted back into negative numbers.
            quotient_positive := - ('1' & quotient_norm_i);
            if quotient_positive(g_op_width-2 downto 0)=(g_op_width-2 downto 0 => '1') then
                -- The result before shift is +1.999999..., increase it to +2:
                quotient_positive_rounded_unsigned := ('0', '1', others => '0');
            else
                quotient_positive_rounded_unsigned := unsigned(quotient_positive); -- MSB is 0, because it is positive.
            end if;
            quotient <= -signed(shift_right(quotient_positive_rounded_unsigned(g_op_width-1 downto 0), quotient_too_big_by_shifts_i));
        end if;
    end process;
    
    clocked_g: if g_latency/=0 generate
        process (res_i, clk_i)
        begin
            if res_i='1' then
                ready_o    <= '0';
                quotient_o <= (others => '0');
            elsif rising_edge(clk_i) then
                ready_o <= start_i;
                if start_i='1' then
                    quotient_o <= quotient;
                end if;
            end if;
        end process;
    end generate clocked_g;
    comb_g: if g_latency=0 generate
        ready_o    <= start_i;
        quotient_o <= quotient;
    end generate comb_g;
end architecture;
