-- Filename: division_srt_radix2_denorm_remainder_e.vhd
-- Created by HDL-SCHEM-Editor at Tue Sep 17 15:24:02 2024
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity division_srt_radix2_denorm_remainder is
    generic (
        constant g_op_width          : natural := 8;
        constant g_shift_upper_limit : integer := 8;
        constant g_divisor_width     : integer := 8;
        constant g_latency           : natural := 0
    );
    port (
        clk_i                         : in  std_logic;
        remainder_norm_fixed_i        : in  signed(g_op_width-1 downto 0);
        remainder_too_big_by_shifts_i : in  integer range 0 to g_shift_upper_limit;
        res_i                         : in  std_logic;
        start_i                       : in  std_logic;
        rem_o                         : out signed(g_divisor_width-1 downto 0)
    );
end entity division_srt_radix2_denorm_remainder;
